/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.adapter;

import cn.taketoday.aop.AfterAdvice;
import cn.taketoday.aop.AfterReturningAdvice;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class AfterReturningAdviceInterceptor
implements MethodInterceptor,
AfterAdvice,
Serializable {
    private final AfterReturningAdvice advice;

    public AfterReturningAdviceInterceptor(AfterReturningAdvice advice) {
        Assert.notNull((Object)advice, (String)"Advice must not be null");
        this.advice = advice;
    }

    @Override
    @Nullable
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object retVal = mi.proceed();
        this.advice.afterReturning(retVal, mi);
        return retVal;
    }
}

