/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.TargetClassAware;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.reflect.MethodInvoker;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TargetInvocation
implements TargetClassAware {
    private static final Map<String, TargetInvocation> targetMap = new HashMap<String, TargetInvocation>();
    private final Method method;
    private final Class<?> targetClass;
    private final AdvisedSupport config;
    private final MethodInvoker invoker;
    private int adviceLength;
    private MethodInterceptor[] interceptors;

    public TargetInvocation(Method method, AdvisedSupport config) {
        this(method, method.getDeclaringClass(), config);
    }

    public TargetInvocation(Method method, Class<?> targetClass, AdvisedSupport config) {
        this.method = method;
        this.config = config;
        this.targetClass = targetClass;
        this.invoker = MethodInvoker.fromMethod((Method)method, targetClass);
    }

    public Method getMethod() {
        return this.method;
    }

    public final Object proceed(Object bean, Object[] args) {
        return this.invoker.invoke(bean, args);
    }

    public final Object invokeAdvice(MethodInvocation invocation, int index) throws Throwable {
        return this.currentAdvice(index).invoke(invocation);
    }

    public final MethodInterceptor currentAdvice(int index) {
        return this.getInterceptors()[index];
    }

    public int getAdviceLength() {
        return this.adviceLength;
    }

    public MethodInvoker getInvoker() {
        return this.invoker;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public MethodInterceptor[] getDynamicInterceptors(AdvisedSupport config) {
        return config.getInterceptors(this.method, this.targetClass);
    }

    public MethodInterceptor[] getInterceptors() {
        MethodInterceptor[] ret = this.interceptors;
        if (ret == null) {
            this.interceptors = this.getDynamicInterceptors(this.config);
            ret = this.interceptors;
            this.adviceLength = ret.length;
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetInvocation)) {
            return false;
        }
        TargetInvocation target = (TargetInvocation)o;
        return this.adviceLength == target.adviceLength && Objects.equals(this.method, target.method) && Objects.equals(this.invoker, target.invoker) && Objects.equals(this.targetClass, target.targetClass) && Objects.equals(this.config, target.config);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.targetClass, this.config);
    }

    public String toString() {
        return "TargetInvocation{method=" + this.method + ", targetClass=" + this.targetClass + ", config=" + this.config + "}";
    }

    public static TargetInvocation getTarget(String key) {
        return targetMap.get(key);
    }

    public static void putTarget(String key, TargetInvocation target) {
        targetMap.put(key, target);
    }
}

