/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.AopInvocationException;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.AopContext;
import cn.taketoday.aop.framework.DynamicStandardMethodInvocation;
import cn.taketoday.aop.framework.StandardMethodInvocation;
import cn.taketoday.aop.framework.TargetInvocation;
import cn.taketoday.util.ObjectUtils;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;

public abstract class StandardProxyInvoker {
    public static Object proceed(Object proxy, Object target, TargetInvocation targetInv, Object[] args) throws Throwable {
        return new StandardMethodInvocation(proxy, target, targetInv, args).proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object staticExposeProceed(Object proxy, Object target, TargetInvocation targetInv, Object[] args) throws Throwable {
        Object oldProxy = null;
        try {
            oldProxy = AopContext.setCurrentProxy(proxy);
            Object object = StandardProxyInvoker.proceed(proxy, target, targetInv, args);
            return object;
        }
        finally {
            AopContext.setCurrentProxy(oldProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dynamicExposeProceed(Object proxy, TargetSource targetSource, TargetInvocation targetInv, Object[] args) throws Throwable {
        Object oldProxy = null;
        Object target = targetSource.getTarget();
        try {
            oldProxy = AopContext.setCurrentProxy(proxy);
            Object object = StandardProxyInvoker.proceed(proxy, target, targetInv, args);
            return object;
        }
        finally {
            AopContext.setCurrentProxy(oldProxy);
            if (target != null && !targetSource.isStatic()) {
                targetSource.releaseTarget(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dynamicProceed(Object proxy, TargetSource targetSource, TargetInvocation targetInv, Object[] args) throws Throwable {
        Object target = targetSource.getTarget();
        try {
            Object object = StandardProxyInvoker.proceed(proxy, target, targetInv, args);
            return object;
        }
        finally {
            if (target != null && !targetSource.isStatic()) {
                targetSource.releaseTarget(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dynamicAdvisedProceed(Object proxy, AdvisedSupport advised, TargetInvocation targetInv, Object[] args) throws Throwable {
        Object target = null;
        Object oldProxy = null;
        boolean restore = false;
        TargetSource targetSource = advised.getTargetSource();
        try {
            if (advised.isExposeProxy()) {
                oldProxy = AopContext.setCurrentProxy(proxy);
                restore = true;
            }
            target = targetSource.getTarget();
            Object[] interceptors = targetInv.getDynamicInterceptors(advised);
            if (ObjectUtils.isEmpty((Object[])interceptors)) {
                Object object = targetInv.proceed(target, args);
                return object;
            }
            Object retVal = new DynamicStandardMethodInvocation(proxy, target, targetInv, args, (MethodInterceptor[])interceptors).proceed();
            StandardProxyInvoker.assertReturnValue(retVal, targetInv.getMethod());
            Object object = retVal;
            return object;
        }
        finally {
            if (target != null && !targetSource.isStatic()) {
                targetSource.releaseTarget(target);
            }
            if (restore) {
                AopContext.setCurrentProxy(oldProxy);
            }
        }
    }

    public static void assertReturnValue(Object retVal, Method method) {
        Class<?> returnType;
        if (retVal == null && (returnType = method.getReturnType()) != Void.TYPE && returnType.isPrimitive()) {
            throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
        }
    }

    public static Object processReturnValue(Object proxy, Object target, Object retVal, Method method) {
        Class<?> returnType;
        if (retVal != null && retVal == target && (returnType = method.getReturnType()) != Object.class && returnType.isInstance(proxy)) {
            retVal = proxy;
        }
        if (retVal == null && (returnType = method.getReturnType()) != Void.TYPE && returnType.isPrimitive()) {
            throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
        }
        return retVal;
    }
}

