/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.AopInfrastructureBean;
import cn.taketoday.aop.framework.ProxyConfig;
import cn.taketoday.aop.framework.ProxyFactory;
import cn.taketoday.beans.factory.Aware;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.core.Ordered;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import java.io.Closeable;

public class ProxyProcessorSupport
extends ProxyConfig
implements Ordered,
BeanClassLoaderAware,
AopInfrastructureBean {
    private static final long serialVersionUID = 1L;
    private int order = Integer.MAX_VALUE;
    @Nullable
    private ClassLoader proxyClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean classLoaderConfigured = false;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setProxyClassLoader(@Nullable ClassLoader classLoader) {
        this.proxyClassLoader = classLoader;
        this.classLoaderConfigured = classLoader != null;
    }

    @Nullable
    protected ClassLoader getProxyClassLoader() {
        return this.proxyClassLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        if (!this.classLoaderConfigured) {
            this.proxyClassLoader = classLoader;
        }
    }

    protected void evaluateProxyInterfaces(Class<?> beanClass, ProxyFactory proxyFactory) {
        Class[] targetInterfaces = ClassUtils.getAllInterfacesForClass(beanClass, (ClassLoader)this.getProxyClassLoader());
        boolean hasReasonableProxyInterface = false;
        for (Class ifc : targetInterfaces) {
            if (this.isConfigurationCallbackInterface(ifc) || this.isInternalLanguageInterface(ifc) || ifc.getMethods().length <= 0) continue;
            hasReasonableProxyInterface = true;
            break;
        }
        if (hasReasonableProxyInterface) {
            for (Class ifc : targetInterfaces) {
                proxyFactory.addInterface(ifc);
            }
        } else {
            proxyFactory.setProxyTargetClass(true);
        }
    }

    protected boolean isConfigurationCallbackInterface(Class<?> ifc) {
        return InitializingBean.class == ifc || Closeable.class == ifc || AutoCloseable.class == ifc || DisposableBean.class == ifc || ObjectUtils.containsElement((Object[])ifc.getInterfaces(), Aware.class);
    }

    protected boolean isInternalLanguageInterface(Class<?> ifc) {
        return ifc.getName().endsWith(".bytecode.proxy.Factory") || ifc.getName().endsWith(".bytebuddy.MockAccess");
    }
}

