/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.AopConfigException;
import cn.taketoday.aop.framework.AopProxy;
import cn.taketoday.aop.framework.ProxyCreatorSupport;
import cn.taketoday.aop.framework.adapter.AdvisorAdapterRegistry;
import cn.taketoday.aop.framework.adapter.DefaultAdvisorAdapterRegistry;
import cn.taketoday.aop.framework.adapter.UnknownAdviceTypeException;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.BeanFactoryUtils;
import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.FactoryBeanNotInitializedException;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;

public class ProxyFactoryBean
extends ProxyCreatorSupport
implements FactoryBean<Object>,
BeanClassLoaderAware,
BeanFactoryAware {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ProxyFactoryBean.class);
    public static final String GLOBAL_SUFFIX = "*";
    @Nullable
    private String[] interceptorNames;
    @Nullable
    private String targetName;
    private boolean autodetectInterfaces = true;
    private boolean singleton = true;
    private AdvisorAdapterRegistry advisorAdapterRegistry = DefaultAdvisorAdapterRegistry.getInstance();
    private boolean freezeProxy = false;
    @Nullable
    private transient ClassLoader proxyClassLoader = ClassUtils.getDefaultClassLoader();
    private transient boolean classLoaderConfigured = false;
    @Nullable
    private transient BeanFactory beanFactory;
    private boolean advisorChainInitialized = false;
    @Nullable
    private Object singletonInstance;

    public void setProxyInterfaces(Class<?>[] proxyInterfaces) {
        this.setInterfaces(proxyInterfaces);
    }

    public void setInterceptorNames(String ... interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setTargetName(@Nullable String targetName) {
        this.targetName = targetName;
    }

    public void setAutodetectInterfaces(boolean autodetectInterfaces) {
        this.autodetectInterfaces = autodetectInterfaces;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.freezeProxy = frozen;
    }

    public void setProxyClassLoader(@Nullable ClassLoader classLoader) {
        this.proxyClassLoader = classLoader;
        this.classLoaderConfigured = classLoader != null;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        if (!this.classLoaderConfigured) {
            this.proxyClassLoader = classLoader;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.checkInterceptorNames();
    }

    @Nullable
    public Object getObject() throws BeansException {
        this.initializeAdvisorChain();
        if (this.isSingleton()) {
            return this.getSingletonInstance();
        }
        if (this.targetName == null) {
            logger.info("Using non-singleton proxies with singleton targets is often undesirable. Enable prototype proxies by setting the 'targetName' property.");
        }
        return this.newPrototypeInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getObjectType() {
        ProxyFactoryBean proxyFactoryBean = this;
        synchronized (proxyFactoryBean) {
            if (this.singletonInstance != null) {
                return this.singletonInstance.getClass();
            }
        }
        return this.createAopProxy().getProxyClass(this.proxyClassLoader);
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    protected Class<?> createCompositeInterface(Class<?>[] interfaces) {
        return ClassUtils.createCompositeInterface((Class[])interfaces, (ClassLoader)this.proxyClassLoader);
    }

    private synchronized Object getSingletonInstance() {
        if (this.singletonInstance == null) {
            this.targetSource = this.freshTargetSource();
            if (this.autodetectInterfaces && this.getProxiedInterfaces().length == 0 && !this.isProxyTargetClass()) {
                Class<?> targetClass = this.getTargetClass();
                if (targetClass == null) {
                    throw new FactoryBeanNotInitializedException("Cannot determine target class for proxy");
                }
                this.setInterfaces(ClassUtils.getAllInterfacesForClass(targetClass, (ClassLoader)this.proxyClassLoader));
            }
            super.setFrozen(this.freezeProxy);
            this.singletonInstance = this.getProxy(this.createAopProxy());
        }
        return this.singletonInstance;
    }

    private synchronized Object newPrototypeInstance() {
        Class<?> targetClass;
        ProxyCreatorSupport copy = new ProxyCreatorSupport(this.getAopProxyFactory());
        TargetSource targetSource = this.freshTargetSource();
        copy.copyConfigurationFrom(this, targetSource, this.freshAdvisorChain());
        if (this.autodetectInterfaces && this.getProxiedInterfaces().length == 0 && !this.isProxyTargetClass() && (targetClass = targetSource.getTargetClass()) != null) {
            copy.setInterfaces(ClassUtils.getAllInterfacesForClass(targetClass, (ClassLoader)this.proxyClassLoader));
        }
        copy.setFrozen(this.freezeProxy);
        return this.getProxy(copy.createAopProxy());
    }

    protected Object getProxy(AopProxy aopProxy) {
        return aopProxy.getProxy(this.proxyClassLoader);
    }

    private void checkInterceptorNames() {
        if (ObjectUtils.isNotEmpty((Object[])this.interceptorNames)) {
            String finalName = this.interceptorNames[this.interceptorNames.length - 1];
            if (this.targetName == null && this.targetSource == EMPTY_TARGET_SOURCE && !finalName.endsWith(GLOBAL_SUFFIX) && !this.isNamedBeanAnAdvisorOrAdvice(finalName)) {
                this.targetName = finalName;
                if (logger.isDebugEnabled()) {
                    logger.debug("Bean with name '{}' concluding interceptor chain is not an advisor class: treating it as a target or TargetSource", (Object)finalName);
                }
                this.interceptorNames = Arrays.copyOf(this.interceptorNames, this.interceptorNames.length - 1);
            }
        }
    }

    private boolean isNamedBeanAnAdvisorOrAdvice(String beanName) {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"No BeanFactory set");
        Class namedBeanClass = this.beanFactory.getType(beanName);
        if (namedBeanClass != null) {
            return Advisor.class.isAssignableFrom(namedBeanClass) || Advice.class.isAssignableFrom(namedBeanClass);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Could not determine type of bean with name '{}' - assuming it is neither an Advisor nor an Advice", (Object)beanName);
        }
        return false;
    }

    private synchronized void initializeAdvisorChain() throws AopConfigException, BeansException {
        if (this.advisorChainInitialized || ObjectUtils.isEmpty((Object[])this.interceptorNames)) {
            return;
        }
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory available anymore (probably due to serialization) - cannot resolve interceptor names " + Arrays.asList(this.interceptorNames));
        }
        if (this.interceptorNames[this.interceptorNames.length - 1].endsWith(GLOBAL_SUFFIX) && this.targetName == null && this.targetSource == EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("Target required after globals");
        }
        for (String name : this.interceptorNames) {
            if (name.endsWith(GLOBAL_SUFFIX)) {
                this.addGlobalAdvisors(this.beanFactory, name.substring(0, name.length() - GLOBAL_SUFFIX.length()));
                continue;
            }
            Object advice = this.singleton || this.beanFactory.isSingleton(name) ? this.beanFactory.getBean(name) : new PrototypePlaceholderAdvisor(name);
            this.addAdvisorOnChainCreation(advice);
        }
        this.advisorChainInitialized = true;
    }

    private List<Advisor> freshAdvisorChain() {
        Advisor[] advisors = this.getAdvisors();
        ArrayList<Advisor> freshAdvisors = new ArrayList<Advisor>(advisors.length);
        for (Advisor advisor : advisors) {
            if (advisor instanceof PrototypePlaceholderAdvisor) {
                PrototypePlaceholderAdvisor pa = (PrototypePlaceholderAdvisor)advisor;
                if (logger.isDebugEnabled()) {
                    logger.debug("Refreshing bean named '{}'", (Object)pa.getBeanName());
                }
                if (this.beanFactory == null) {
                    throw new IllegalStateException("No BeanFactory available anymore (probably due to serialization) - cannot resolve prototype advisor '" + pa.getBeanName() + "'");
                }
                Object bean = this.beanFactory.getBean(pa.getBeanName());
                Advisor refreshedAdvisor = this.namedBeanToAdvisor(bean);
                freshAdvisors.add(refreshedAdvisor);
                continue;
            }
            freshAdvisors.add(advisor);
        }
        return freshAdvisors;
    }

    private void addGlobalAdvisors(BeanFactory beanFactory, String prefix) {
        Set globalAdvisorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((BeanFactory)beanFactory, Advisor.class);
        Set globalInterceptorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((BeanFactory)beanFactory, Interceptor.class);
        if (globalAdvisorNames.size() > 0 || globalInterceptorNames.size() > 0) {
            ArrayList<Object> beans = new ArrayList<Object>(globalAdvisorNames.size() + globalInterceptorNames.size());
            for (String string : globalAdvisorNames) {
                if (!string.startsWith(prefix)) continue;
                beans.add(beanFactory.getBean(string));
            }
            for (String string : globalInterceptorNames) {
                if (!string.startsWith(prefix)) continue;
                beans.add(beanFactory.getBean(string));
            }
            AnnotationAwareOrderComparator.sort(beans);
            for (Object e : beans) {
                this.addAdvisorOnChainCreation(e);
            }
        }
    }

    private void addAdvisorOnChainCreation(Object next) {
        this.addAdvisor(this.namedBeanToAdvisor(next));
    }

    private TargetSource freshTargetSource() {
        Object target;
        if (this.targetName == null) {
            return this.targetSource;
        }
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory available anymore (probably due to serialization) - cannot resolve target with name '" + this.targetName + "'");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Refreshing target with name '{}'", (Object)this.targetName);
        }
        return (target = this.beanFactory.getBean(this.targetName)) instanceof TargetSource ? (TargetSource)target : new SingletonTargetSource(target);
    }

    private Advisor namedBeanToAdvisor(Object next) {
        try {
            return this.advisorAdapterRegistry.wrap(next);
        }
        catch (UnknownAdviceTypeException ex) {
            throw new AopConfigException("Unknown advisor type " + next.getClass() + "; can only include Advisor or Advice type beans in interceptorNames chain except for last entry which may also be target instance or TargetSource", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void adviceChanged() {
        super.adviceChanged();
        if (this.singleton) {
            logger.debug("Advice has changed; re-caching singleton instance");
            ProxyFactoryBean proxyFactoryBean = this;
            synchronized (proxyFactoryBean) {
                this.singletonInstance = null;
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.proxyClassLoader = ClassUtils.getDefaultClassLoader();
    }

    private static class PrototypePlaceholderAdvisor
    implements Advisor,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String message;
        private final String beanName;

        public PrototypePlaceholderAdvisor(String beanName) {
            this.beanName = beanName;
            this.message = "Placeholder for prototype Advisor/Advice with bean name '" + beanName + "'";
        }

        public String getBeanName() {
            return this.beanName;
        }

        @Override
        public Advice getAdvice() {
            throw new UnsupportedOperationException("Cannot invoke methods: " + this.message);
        }

        public String toString() {
            return this.message;
        }
    }
}

