/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.AdvisedSupportListener;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.AopProxy;
import cn.taketoday.aop.framework.AopProxyFactory;
import cn.taketoday.aop.framework.DefaultAopProxyFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.ArrayList;

public class ProxyCreatorSupport
extends AdvisedSupport {
    private static final long serialVersionUID = 1L;
    private boolean active = false;
    private AopProxyFactory aopProxyFactory;
    @Nullable
    private ArrayList<AdvisedSupportListener> listeners;

    public ProxyCreatorSupport() {
        this.aopProxyFactory = DefaultAopProxyFactory.INSTANCE;
    }

    public ProxyCreatorSupport(AopProxyFactory aopProxyFactory) {
        Assert.notNull((Object)aopProxyFactory, (String)"AopProxyFactory is required");
        this.aopProxyFactory = aopProxyFactory;
    }

    public void setAopProxyFactory(AopProxyFactory aopProxyFactory) {
        Assert.notNull((Object)aopProxyFactory, (String)"AopProxyFactory is required");
        this.aopProxyFactory = aopProxyFactory;
    }

    public AopProxyFactory getAopProxyFactory() {
        return this.aopProxyFactory;
    }

    protected final synchronized AopProxy createAopProxy() {
        if (!this.active) {
            this.activate();
        }
        return this.aopProxyFactory.createAopProxy(this);
    }

    private void activate() {
        this.active = true;
        if (this.listeners != null) {
            for (AdvisedSupportListener listener : this.listeners) {
                listener.activated(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void adviceChanged() {
        super.adviceChanged();
        ProxyCreatorSupport proxyCreatorSupport = this;
        synchronized (proxyCreatorSupport) {
            if (this.active && this.listeners != null) {
                for (AdvisedSupportListener listener : this.listeners) {
                    listener.adviceChanged(this);
                }
            }
        }
    }

    protected final synchronized boolean isActive() {
        return this.active;
    }

    public void addListener(AdvisedSupportListener listener) {
        Assert.notNull((Object)listener, (String)"AdvisedSupportListener is required");
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(listener);
    }

    public void removeListener(AdvisedSupportListener listener) {
        Assert.notNull((Object)listener, (String)"AdvisedSupportListener is required");
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }
}

