/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.AopInvocationException;
import cn.taketoday.aop.RawTargetAccess;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.Advised;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.AopContext;
import cn.taketoday.aop.framework.AopProxy;
import cn.taketoday.aop.framework.AopProxyUtils;
import cn.taketoday.aop.framework.DefaultMethodInvocation;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.core.DecoratingProxy;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.aopalliance.intercept.MethodInterceptor;

final class JdkDynamicAopProxy
implements AopProxy,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdkDynamicAopProxy.class);
    private final AdvisedSupport advised;
    private boolean equalsDefined;
    private boolean hashCodeDefined;
    private final Class<?>[] proxiedInterfaces;

    public JdkDynamicAopProxy(AdvisedSupport config) {
        Assert.notNull((Object)config, (String)"AdvisedSupport must not be null");
        this.advised = config;
        this.proxiedInterfaces = AopProxyUtils.completeProxiedInterfaces(this.advised, true);
        this.findDefinedEqualsAndHashCodeMethods(this.proxiedInterfaces);
    }

    @Override
    public Object getProxy() {
        return this.getProxy(ClassUtils.getDefaultClassLoader());
    }

    @Override
    public Object getProxy(@Nullable ClassLoader classLoader) {
        if (logger.isTraceEnabled()) {
            logger.trace("Creating JDK dynamic proxy: {}", (Object)this.advised.getTargetSource());
        }
        return Proxy.newProxyInstance(this.determineClassLoader(classLoader), this.proxiedInterfaces, (InvocationHandler)this);
    }

    @Override
    public Class<?> getProxyClass(@Nullable ClassLoader classLoader) {
        return Proxy.getProxyClass(this.determineClassLoader(classLoader), this.proxiedInterfaces);
    }

    private ClassLoader determineClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return this.getClass().getClassLoader();
        }
        if (classLoader.getParent() == null) {
            ClassLoader aopClassLoader = this.getClass().getClassLoader();
            for (ClassLoader aopParent = aopClassLoader.getParent(); aopParent != null; aopParent = aopParent.getParent()) {
                if (classLoader != aopParent) continue;
                return aopClassLoader;
            }
        }
        return classLoader;
    }

    void findDefinedEqualsAndHashCodeMethods(Class<?>[] proxiedInterfaces) {
        for (Class<?> proxiedInterface : proxiedInterfaces) {
            Method[] methods;
            for (Method method : methods = proxiedInterface.getDeclaredMethods()) {
                if (ReflectionUtils.isEqualsMethod((Method)method)) {
                    this.equalsDefined = true;
                }
                if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                    this.hashCodeDefined = true;
                }
                if (!this.equalsDefined || !this.hashCodeDefined) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        boolean setProxyContext;
        Object oldProxy;
        block26: {
            Class<?> returnType;
            Object retVal;
            Class<?> targetClass;
            Object[] chain;
            Object target;
            TargetSource targetSource;
            block24: {
                Object object2;
                block25: {
                    Class<Advised> declaringClass;
                    block22: {
                        Class<?> clazz;
                        block23: {
                            block20: {
                                Integer n;
                                block21: {
                                    block18: {
                                        Boolean bl;
                                        block19: {
                                            oldProxy = null;
                                            setProxyContext = false;
                                            targetSource = this.advised.getTargetSource();
                                            target = null;
                                            try {
                                                if (this.equalsDefined || !ReflectionUtils.isEqualsMethod((Method)method)) break block18;
                                                bl = this.equals(args[0]);
                                                if (target == null || targetSource.isStatic()) break block19;
                                            }
                                            catch (Throwable throwable) {
                                                if (target != null && !targetSource.isStatic()) {
                                                    targetSource.releaseTarget(target);
                                                }
                                                if (setProxyContext) {
                                                    AopContext.setCurrentProxy(oldProxy);
                                                }
                                                throw throwable;
                                            }
                                            targetSource.releaseTarget(target);
                                        }
                                        if (setProxyContext) {
                                            AopContext.setCurrentProxy(oldProxy);
                                        }
                                        return bl;
                                    }
                                    if (this.hashCodeDefined || !ReflectionUtils.isHashCodeMethod((Method)method)) break block20;
                                    n = this.hashCode();
                                    if (target == null || targetSource.isStatic()) break block21;
                                    targetSource.releaseTarget(target);
                                }
                                if (setProxyContext) {
                                    AopContext.setCurrentProxy(oldProxy);
                                }
                                return n;
                            }
                            declaringClass = method.getDeclaringClass();
                            if (declaringClass != DecoratingProxy.class) break block22;
                            clazz = AopProxyUtils.ultimateTargetClass(this.advised);
                            if (target == null || targetSource.isStatic()) break block23;
                            targetSource.releaseTarget(target);
                        }
                        if (setProxyContext) {
                            AopContext.setCurrentProxy(oldProxy);
                        }
                        return clazz;
                    }
                    if (this.advised.isOpaque() || !declaringClass.isInterface() || !declaringClass.isAssignableFrom(Advised.class)) break block24;
                    object2 = AopUtils.invokeJoinpointUsingReflection(this.advised, method, args);
                    if (target == null || targetSource.isStatic()) break block25;
                    targetSource.releaseTarget(target);
                }
                if (setProxyContext) {
                    AopContext.setCurrentProxy(oldProxy);
                }
                return object2;
            }
            if (this.advised.isExposeProxy()) {
                oldProxy = AopContext.setCurrentProxy(proxy);
                setProxyContext = true;
            }
            if (ObjectUtils.isEmpty((Object[])(chain = this.advised.getInterceptors(method, targetClass = (target = targetSource.getTarget()) != null ? target.getClass() : null)))) {
                Object[] argsToUse = ClassUtils.adaptArgumentsIfNecessary((Method)method, (Object[])args);
                retVal = AopUtils.invokeJoinpointUsingReflection(target, method, argsToUse);
            } else {
                retVal = new DefaultMethodInvocation(proxy, target, method, targetClass, args, (MethodInterceptor[])chain).proceed();
            }
            if (retVal != null && retVal == target && (returnType = method.getReturnType()) != Object.class && returnType.isInstance(proxy) && !RawTargetAccess.class.isAssignableFrom(method.getDeclaringClass())) {
                retVal = proxy;
            }
            if (retVal == null && (returnType = method.getReturnType()) != Void.TYPE && returnType.isPrimitive()) {
                throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
            }
            object = retVal;
            if (target == null || targetSource.isStatic()) break block26;
            targetSource.releaseTarget(target);
        }
        if (setProxyContext) {
            AopContext.setCurrentProxy(oldProxy);
        }
        return object;
    }

    public boolean equals(Object other) {
        JdkDynamicAopProxy otherProxy;
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof JdkDynamicAopProxy) {
            otherProxy = (JdkDynamicAopProxy)other;
        } else if (Proxy.isProxyClass(other.getClass())) {
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            if (!(ih instanceof JdkDynamicAopProxy)) {
                return false;
            }
            otherProxy = (JdkDynamicAopProxy)ih;
        } else {
            return false;
        }
        return AopProxyUtils.equalsInProxy(this.advised, otherProxy.advised);
    }

    public int hashCode() {
        return JdkDynamicAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }
}

