/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.InterceptorChainFactory;
import cn.taketoday.aop.framework.AbstractMethodInvocation;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DefaultMethodInvocation
extends AbstractMethodInvocation
implements MethodInvocation {
    private static final long serialVersionUID = 1L;
    private final Object proxy;
    protected Object[] args;
    @Nullable
    protected final Object target;
    protected final Method method;
    @Nullable
    protected final Class<?> targetClass;
    protected final MethodInterceptor[] advices;
    private int currentAdviceIndex = 0;
    private final int adviceLength;

    public DefaultMethodInvocation(Object proxy, Method method, Class<?> targetClass, Object[] arguments) {
        this(proxy, null, method, targetClass, arguments, InterceptorChainFactory.EMPTY_INTERCEPTOR);
    }

    public DefaultMethodInvocation(Object proxy, @Nullable Object target, Method method, @Nullable Class<?> targetClass, Object[] arguments, MethodInterceptor[] advices) {
        this.proxy = proxy;
        this.target = target;
        this.method = method;
        this.targetClass = targetClass;
        this.args = ClassUtils.adaptArgumentsIfNecessary((Method)method, (Object[])arguments);
        this.advices = advices;
        this.adviceLength = advices != null ? advices.length : 0;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getArguments() {
        return this.args;
    }

    @Override
    public void setArguments(Object[] arguments) {
        this.args = arguments;
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }

    @Override
    protected Object invokeJoinPoint() throws Throwable {
        return AopUtils.invokeJoinpointUsingReflection(this.target, this.method, this.args);
    }

    @Override
    protected boolean hasInterceptor() {
        return this.currentAdviceIndex < this.adviceLength;
    }

    @Override
    protected Object executeInterceptor() throws Throwable {
        return this.advices[this.currentAdviceIndex++].invoke(this);
    }

    @Override
    public Object getThis() {
        return this.target;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public AccessibleObject getStaticPart() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMethodInvocation)) {
            return false;
        }
        DefaultMethodInvocation that = (DefaultMethodInvocation)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.currentAdviceIndex == that.currentAdviceIndex && this.adviceLength == that.adviceLength && Arrays.equals(this.args, that.args) && Objects.equals(this.target, that.target) && Objects.equals(this.method, that.method) && Arrays.equals(this.advices, that.advices);
    }

    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.target, this.method);
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + Arrays.hashCode(this.advices);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultMethodInvocation: ");
        sb.append(this.method).append("; ");
        if (this.target == null) {
            sb.append("target is null");
        } else {
            sb.append("target is of class [").append(this.target.getClass().getName()).append(']');
        }
        return sb.toString();
    }
}

