/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.AopConfigException;
import cn.taketoday.aop.framework.AopProxy;
import cn.taketoday.aop.framework.AopProxyFactory;
import cn.taketoday.aop.framework.JdkDynamicAopProxy;
import cn.taketoday.aop.framework.SerializationCglibAopProxy;
import cn.taketoday.aop.framework.StandardProxy;
import cn.taketoday.util.ClassUtils;
import java.io.Serializable;
import java.lang.reflect.Proxy;

public class DefaultAopProxyFactory
implements AopProxyFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final DefaultAopProxyFactory INSTANCE = new DefaultAopProxyFactory();

    @Override
    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class<?> targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface() || Proxy.isProxyClass(targetClass) || ClassUtils.isLambdaClass(targetClass)) {
                return new JdkDynamicAopProxy(config);
            }
            return new SerializationCglibAopProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class<?>[] ifcs = config.getProxiedInterfaces();
        return ifcs.length == 0 || ifcs.length == 1 && StandardProxy.class.isAssignableFrom(ifcs[0]);
    }
}

