/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.AopInvocationException;
import cn.taketoday.aop.RawTargetAccess;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.Advised;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.AopConfigException;
import cn.taketoday.aop.framework.AopContext;
import cn.taketoday.aop.framework.AopProxy;
import cn.taketoday.aop.framework.AopProxyUtils;
import cn.taketoday.aop.framework.DefaultMethodInvocation;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.bytecode.core.ClassLoaderAwareGeneratorStrategy;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.bytecode.core.GeneratorStrategy;
import cn.taketoday.bytecode.core.NamingPolicy;
import cn.taketoday.bytecode.proxy.Callback;
import cn.taketoday.bytecode.proxy.CallbackFilter;
import cn.taketoday.bytecode.proxy.Dispatcher;
import cn.taketoday.bytecode.proxy.Enhancer;
import cn.taketoday.bytecode.proxy.Factory;
import cn.taketoday.bytecode.proxy.MethodProxy;
import cn.taketoday.bytecode.proxy.NoOp;
import cn.taketoday.core.SmartClassLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.aopalliance.intercept.MethodInterceptor;

class CglibAopProxy
implements AopProxy,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(CglibAopProxy.class);
    private static final Map<Class<?>, Boolean> validatedClasses = new WeakHashMap();
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    private static final int DISPATCH_TARGET = 3;
    private static final int DISPATCH_ADVISED = 4;
    private static final int INVOKE_EQUALS = 5;
    private static final int INVOKE_HASHCODE = 6;
    private transient Map<Method, Integer> fixedInterceptorMap = Collections.emptyMap();
    private transient int fixedInterceptorOffset;
    final AdvisedSupport config;
    @Nullable
    protected Object[] constructorArgs;
    @Nullable
    protected Class<?>[] constructorArgTypes;

    public CglibAopProxy(AdvisedSupport config) {
        Assert.notNull((Object)config, (String)"AdvisedSupport must not be null");
        this.config = config;
    }

    public void setConstructorArguments(@Nullable Object[] constructorArgs, @Nullable Class<?>[] constructorArgTypes) {
        if (constructorArgs == null || constructorArgTypes == null) {
            throw new IllegalArgumentException("Both 'constructorArgs' and 'constructorArgTypes' need to be specified");
        }
        if (constructorArgs.length != constructorArgTypes.length) {
            throw new IllegalArgumentException("Number of 'constructorArgs' (" + constructorArgs.length + ") must match number of 'constructorArgTypes' (" + constructorArgTypes.length + ")");
        }
        this.constructorArgs = constructorArgs;
        this.constructorArgTypes = constructorArgTypes;
    }

    @Override
    public Object getProxy() {
        return this.buildProxy(null, false);
    }

    @Override
    public Object getProxy(@Nullable ClassLoader classLoader) {
        return this.buildProxy(classLoader, false);
    }

    @Override
    public Class<?> getProxyClass(@Nullable ClassLoader classLoader) {
        return (Class)this.buildProxy(classLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object buildProxy(@Nullable ClassLoader classLoader, boolean classOnly) {
        if (log.isTraceEnabled()) {
            log.trace("Creating CGLIB proxy: {}", (Object)this.config.getTargetSource());
        }
        Class<?> rootClass = this.config.getTargetClass();
        Assert.state((rootClass != null ? 1 : 0) != 0, (String)"Target class must be available for creating a CGLIB proxy");
        Class<?> proxySuperClass = rootClass;
        if (rootClass.getName().contains("$$")) {
            Class<?>[] additionalInterfaces;
            proxySuperClass = rootClass.getSuperclass();
            for (Class<?> additionalInterface : additionalInterfaces = rootClass.getInterfaces()) {
                this.config.addInterface(additionalInterface);
            }
        }
        this.validateClassIfNecessary(proxySuperClass, classLoader);
        Enhancer enhancer = this.createEnhancer();
        if (classLoader != null) {
            SmartClassLoader smartClassLoader;
            enhancer.setClassLoader(classLoader);
            if (classLoader instanceof SmartClassLoader && (smartClassLoader = (SmartClassLoader)classLoader).isClassReloadable(proxySuperClass)) {
                enhancer.setUseCache(false);
            }
        }
        enhancer.setAttemptLoad(true);
        enhancer.setSuperclass(proxySuperClass);
        enhancer.setNamingPolicy((NamingPolicy)NamingPolicy.forInfrastructure());
        enhancer.setInterfaces((Class[])AopProxyUtils.completeProxiedInterfaces(this.config));
        enhancer.setStrategy((GeneratorStrategy)new ClassLoaderAwareGeneratorStrategy(classLoader));
        Callback[] callbacks = this.getCallbacks(rootClass);
        Class[] types = new Class[callbacks.length];
        for (int x = 0; x < types.length; ++x) {
            types[x] = callbacks[x].getClass();
        }
        ProxyCallbackFilter filter = new ProxyCallbackFilter(this.config.getConfigurationOnlyCopy(), this.fixedInterceptorMap, this.fixedInterceptorOffset);
        enhancer.setCallbackFilter((CallbackFilter)filter);
        enhancer.setCallbackTypes(types);
        try {
            Object object = classOnly ? this.createProxyClass(enhancer) : this.createProxyClassAndInstance(enhancer, callbacks);
            filter.advised.reduceToAdvisorKey();
            return object;
        }
        catch (Throwable throwable) {
            try {
                filter.advised.reduceToAdvisorKey();
                throw throwable;
            }
            catch (CodeGenerationException | IllegalArgumentException ex) {
                throw new AopConfigException("Could not generate CGLIB subclass of " + this.config.getTargetClass() + ": Common causes of this problem include using a final class or a non-visible class", ex);
            }
            catch (Throwable ex) {
                throw new AopConfigException("Unexpected AOP exception", ex);
            }
        }
    }

    protected Class<?> createProxyClass(Enhancer enhancer) {
        enhancer.setInterceptDuringConstruction(false);
        return enhancer.createClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateClassIfNecessary(Class<?> proxySuperClass, @Nullable ClassLoader proxyClassLoader) {
        if (!this.config.isOptimize() && log.isInfoEnabled()) {
            Map<Class<?>, Boolean> map = validatedClasses;
            synchronized (map) {
                if (!validatedClasses.containsKey(proxySuperClass)) {
                    this.doValidateClass(proxySuperClass, proxyClassLoader, ClassUtils.getAllInterfacesForClassAsSet(proxySuperClass));
                    validatedClasses.put(proxySuperClass, Boolean.TRUE);
                }
            }
        }
    }

    void doValidateClass(Class<?> proxySuperClass, @Nullable ClassLoader proxyClassLoader, Set<Class<?>> ifcs) {
        if (proxySuperClass != Object.class) {
            Method[] methods;
            for (Method method : methods = proxySuperClass.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isPrivate(mod)) continue;
                if (Modifier.isFinal(mod)) {
                    if (log.isWarnEnabled() && CglibAopProxy.implementsInterface(method, ifcs)) {
                        log.warn("Unable to proxy interface-implementing method [{}] because it is marked as final: Consider using interface-based JDK proxies instead!", (Object)method);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Final method [{}] cannot get proxied via CGLIB: Calls to this method will NOT be routed to the target instance and might lead to NPEs against uninitialized fields in the proxy instance.", (Object)method);
                    continue;
                }
                if (!log.isDebugEnabled() || Modifier.isPublic(mod) || Modifier.isProtected(mod) || proxyClassLoader == null || proxySuperClass.getClassLoader() == proxyClassLoader) continue;
                log.debug("Method [{}] is package-visible across different ClassLoaders and cannot get proxied via CGLIB: Declare this method as public or protected if you need to support invocations through the proxy.", (Object)method);
            }
            this.doValidateClass(proxySuperClass.getSuperclass(), proxyClassLoader, ifcs);
        }
    }

    static boolean implementsInterface(Method method, Set<Class<?>> ifcs) {
        for (Class<?> ifc : ifcs) {
            if (!ReflectionUtils.hasMethod(ifc, (Method)method)) continue;
            return true;
        }
        return false;
    }

    protected Object createProxyClassAndInstance(Enhancer enhancer, Callback[] callbacks) throws Exception {
        enhancer.setInterceptDuringConstruction(false);
        enhancer.setCallbacks(callbacks);
        return this.constructorArgs != null && this.constructorArgTypes != null ? enhancer.create((Class[])this.constructorArgTypes, this.constructorArgs) : enhancer.create();
    }

    protected Enhancer createEnhancer() {
        return new Enhancer();
    }

    private Callback[] getCallbacks(Class<?> rootClass) throws Exception {
        boolean exposeProxy = this.config.isExposeProxy();
        boolean isFrozen = this.config.isFrozen();
        boolean isStatic = this.config.getTargetSource().isStatic();
        DynamicAdvisedInterceptor aopInterceptor = new DynamicAdvisedInterceptor(this.config);
        Record targetInterceptor = exposeProxy ? (isStatic ? new StaticUnadvisedExposedInterceptor(this.config.getTargetSource().getTarget()) : new DynamicUnadvisedExposedInterceptor(this.config.getTargetSource())) : (isStatic ? new StaticUnadvisedInterceptor(this.config.getTargetSource().getTarget()) : new DynamicUnadvisedInterceptor(this.config.getTargetSource()));
        Serializable targetDispatcher = isStatic ? new StaticDispatcher(this.config.getTargetSource().getTarget()) : new SerializableNoOp();
        Callback[] mainCallbacks = new Callback[]{aopInterceptor, targetInterceptor, new SerializableNoOp(), targetDispatcher, new AdvisedDispatcher(this.config), new EqualsInterceptor(this.config), new HashCodeInterceptor(this.config)};
        if (isStatic && isFrozen) {
            Method[] methods = rootClass.getMethods();
            int methodsCount = methods.length;
            ArrayList<FixedChainStaticTargetInterceptor> fixedCallbacks = new ArrayList<FixedChainStaticTargetInterceptor>(methodsCount);
            this.fixedInterceptorMap = CollectionUtils.newHashMap((int)methodsCount);
            int advicedMethodCount = methodsCount;
            for (int x = 0; x < methodsCount; ++x) {
                Method method = methods[x];
                if (method.getDeclaringClass() == Object.class) {
                    --advicedMethodCount;
                    continue;
                }
                MethodInterceptor[] chain = this.config.getInterceptors(method, rootClass);
                fixedCallbacks.add(new FixedChainStaticTargetInterceptor(chain, this.config));
                this.fixedInterceptorMap.put(method, x - (methodsCount - advicedMethodCount));
            }
            Callback[] callbacks = new Callback[mainCallbacks.length + advicedMethodCount];
            System.arraycopy(mainCallbacks, 0, callbacks, 0, mainCallbacks.length);
            System.arraycopy(fixedCallbacks.toArray(new Callback[0]), 0, callbacks, mainCallbacks.length, advicedMethodCount);
            this.fixedInterceptorOffset = mainCallbacks.length;
            return callbacks;
        }
        return mainCallbacks;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CglibAopProxy && AopProxyUtils.equalsInProxy(this.config, ((CglibAopProxy)other).config);
    }

    public int hashCode() {
        return CglibAopProxy.class.hashCode() * 13 + this.config.getTargetSource().hashCode();
    }

    @Nullable
    private static Object invokeMethod(@Nullable Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        try {
            return methodProxy.invoke(target, args);
        }
        catch (CodeGenerationException ex) {
            CglibAopProxy.logFastClassGenerationFailure(method);
            return AopUtils.invokeJoinpointUsingReflection(target, method, args);
        }
    }

    @Nullable
    private static Object processReturnValue(Object proxy, @Nullable Object target, Method method, @Nullable Object retVal) {
        Class<?> returnType;
        if (retVal != null && retVal == target && !RawTargetAccess.class.isAssignableFrom(method.getDeclaringClass())) {
            retVal = proxy;
        }
        if (retVal == null && (returnType = method.getReturnType()) != Void.TYPE && returnType.isPrimitive()) {
            throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
        }
        return retVal;
    }

    static boolean isMethodProxyCompatible(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getDeclaringClass() != Object.class && !ReflectionUtils.isEqualsMethod((Method)method) && !ReflectionUtils.isHashCodeMethod((Method)method) && !ReflectionUtils.isToStringMethod((Method)method);
    }

    static void logFastClassGenerationFailure(Method method) {
        log.debug("Failed to generate CGLIB fast class for method: {}", (Object)method);
    }

    private record ProxyCallbackFilter(AdvisedSupport advised, Map<Method, Integer> fixedInterceptorMap, int fixedInterceptorOffset) implements CallbackFilter
    {
        public int accept(Method method) {
            if (ReflectionUtils.isFinalizeMethod((Method)method)) {
                log.trace("Found finalize() method - using NO_OVERRIDE");
                return 2;
            }
            if (!this.advised.isOpaque() && method.getDeclaringClass().isInterface() && method.getDeclaringClass().isAssignableFrom(Advised.class)) {
                if (log.isTraceEnabled()) {
                    log.trace("Method is declared on Advised interface: {}", (Object)method);
                }
                return 4;
            }
            if (ReflectionUtils.isEqualsMethod((Method)method)) {
                if (log.isTraceEnabled()) {
                    log.trace("Found 'equals' method: {}", (Object)method);
                }
                return 5;
            }
            if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                if (log.isTraceEnabled()) {
                    log.trace("Found 'hashCode' method: {}", (Object)method);
                }
                return 6;
            }
            Class<?> targetClass = this.advised.getTargetClass();
            Object[] chain = this.advised.getInterceptors(method, targetClass);
            boolean haveAdvice = ObjectUtils.isNotEmpty((Object[])chain);
            boolean exposeProxy = this.advised.isExposeProxy();
            boolean isStatic = this.advised.getTargetSource().isStatic();
            boolean isFrozen = this.advised.isFrozen();
            if (haveAdvice || !isFrozen) {
                if (exposeProxy) {
                    if (log.isTraceEnabled()) {
                        log.trace("Must expose proxy on advised method: {}", (Object)method);
                    }
                    return 0;
                }
                if (isStatic && isFrozen && this.fixedInterceptorMap.containsKey(method)) {
                    if (log.isTraceEnabled()) {
                        log.trace("Method has advice and optimizations are enabled: {}", (Object)method);
                    }
                    int index = this.fixedInterceptorMap.get(method);
                    return index + this.fixedInterceptorOffset;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Unable to apply any optimizations to advised method: {}", (Object)method);
                }
                return 0;
            }
            if (exposeProxy || !isStatic) {
                return 1;
            }
            Class<?> returnType = method.getReturnType();
            if (targetClass != null && returnType.isAssignableFrom(targetClass)) {
                if (log.isTraceEnabled()) {
                    log.trace("Method return type is assignable from target type and may therefore return 'this' - using INVOKE_TARGET: {}", (Object)method);
                }
                return 1;
            }
            if (log.isTraceEnabled()) {
                log.trace("Method return type ensures 'this' cannot be returned - using DISPATCH_TARGET: {}", (Object)method);
            }
            return 3;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProxyCallbackFilter)) {
                return false;
            }
            ProxyCallbackFilter otherCallbackFilter = (ProxyCallbackFilter)other;
            AdvisedSupport otherAdvised = otherCallbackFilter.advised;
            return this.advised.advisorKey.equals(otherAdvised.advisorKey) && AopProxyUtils.equalsProxiedInterfaces(this.advised, otherAdvised) && ObjectUtils.nullSafeEquals(this.advised.getTargetClass(), otherAdvised.getTargetClass()) && this.advised.getTargetSource().isStatic() == otherAdvised.getTargetSource().isStatic() && this.advised.isFrozen() == otherAdvised.isFrozen() && this.advised.isExposeProxy() == otherAdvised.isExposeProxy() && this.advised.isOpaque() == otherAdvised.isOpaque();
        }

        @Override
        public int hashCode() {
            return this.advised.advisorKey.hashCode();
        }
    }

    private record DynamicAdvisedInterceptor(AdvisedSupport advised) implements cn.taketoday.bytecode.proxy.MethodInterceptor,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            boolean restore = false;
            Object target = null;
            TargetSource targetSource = this.advised.getTargetSource();
            try {
                Object retVal;
                Class<?> targetClass;
                MethodInterceptor[] chain;
                if (this.advised.isExposeProxy()) {
                    oldProxy = AopContext.setCurrentProxy(proxy);
                    restore = true;
                }
                if ((chain = this.advised.getInterceptors(method, targetClass = (target = targetSource.getTarget()) != null ? target.getClass() : null)).length == 0 && CglibAopProxy.isMethodProxyCompatible(method)) {
                    Object[] argsToUse = ClassUtils.adaptArgumentsIfNecessary((Method)method, (Object[])args);
                    retVal = CglibAopProxy.invokeMethod(target, method, argsToUse, methodProxy);
                } else {
                    retVal = new CglibMethodInvocation(proxy, target, method, targetClass, methodProxy, args, chain).proceed();
                }
                Object object = CglibAopProxy.processReturnValue(proxy, target, method, retVal);
                return object;
            }
            finally {
                if (target != null && !targetSource.isStatic()) {
                    targetSource.releaseTarget(target);
                }
                if (restore) {
                    AopContext.setCurrentProxy(oldProxy);
                }
            }
        }
    }

    private record StaticUnadvisedExposedInterceptor(@Nullable Object target) implements cn.taketoday.bytecode.proxy.MethodInterceptor,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = CglibAopProxy.invokeMethod(this.target, method, args, methodProxy);
                Object object = CglibAopProxy.processReturnValue(proxy, this.target, method, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
            }
        }
    }

    private record DynamicUnadvisedExposedInterceptor(TargetSource targetSource) implements cn.taketoday.bytecode.proxy.MethodInterceptor,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            Object target = this.targetSource.getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = CglibAopProxy.invokeMethod(target, method, args, methodProxy);
                Object object = CglibAopProxy.processReturnValue(proxy, target, method, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
                if (target != null) {
                    this.targetSource.releaseTarget(target);
                }
            }
        }
    }

    private record StaticUnadvisedInterceptor(@Nullable Object target) implements cn.taketoday.bytecode.proxy.MethodInterceptor,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = CglibAopProxy.invokeMethod(this.target, method, args, methodProxy);
            return CglibAopProxy.processReturnValue(proxy, this.target, method, retVal);
        }
    }

    private record DynamicUnadvisedInterceptor(TargetSource targetSource) implements cn.taketoday.bytecode.proxy.MethodInterceptor,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object target = this.targetSource.getTarget();
            try {
                Object retVal = CglibAopProxy.invokeMethod(target, method, args, methodProxy);
                Object object = CglibAopProxy.processReturnValue(proxy, target, method, retVal);
                return object;
            }
            finally {
                if (target != null) {
                    this.targetSource.releaseTarget(target);
                }
            }
        }
    }

    private record StaticDispatcher(@Nullable Object target) implements Dispatcher,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        @Nullable
        public Object loadObject() {
            return this.target;
        }
    }

    public static class SerializableNoOp
    implements NoOp,
    Serializable {
        private static final long serialVersionUID = 1L;
    }

    private record AdvisedDispatcher(AdvisedSupport advised) implements Dispatcher,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        public Object loadObject() {
            return this.advised;
        }
    }

    private record EqualsInterceptor(AdvisedSupport advised) implements cn.taketoday.bytecode.proxy.MethodInterceptor,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            Object other = args[0];
            if (proxy == other) {
                return true;
            }
            if (other instanceof Factory) {
                Callback callback = ((Factory)other).getCallback(5);
                if (!(callback instanceof EqualsInterceptor)) {
                    return false;
                }
                AdvisedSupport otherAdvised = ((EqualsInterceptor)callback).advised;
                return AopProxyUtils.equalsInProxy(this.advised, otherAdvised);
            }
            return false;
        }
    }

    private record HashCodeInterceptor(AdvisedSupport advised) implements cn.taketoday.bytecode.proxy.MethodInterceptor,
    Serializable
    {
        private static final long serialVersionUID = 1L;

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            return CglibAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
        }
    }

    static class FixedChainStaticTargetInterceptor
    implements cn.taketoday.bytecode.proxy.MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        @Nullable
        final Object target;
        @Nullable
        final Class<?> targetClass;
        final MethodInterceptor[] adviceChain;

        public FixedChainStaticTargetInterceptor(MethodInterceptor[] adviceChain, AdvisedSupport config) throws Exception {
            this.adviceChain = adviceChain;
            this.targetClass = config.getTargetClass();
            this.target = config.getTargetSource().getTarget();
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = new CglibMethodInvocation(proxy, this.target, method, this.targetClass, methodProxy, args, this.adviceChain).proceed();
            return CglibAopProxy.processReturnValue(proxy, this.target, method, retVal);
        }
    }

    static class CglibMethodInvocation
    extends DefaultMethodInvocation {
        private static final long serialVersionUID = 1L;
        @Nullable
        final MethodProxy methodProxy;

        public CglibMethodInvocation(Object proxyObject, @Nullable Object target, Method method, @Nullable Class<?> targetClass, MethodProxy methodProxy, Object[] arguments, MethodInterceptor[] advices) {
            super(proxyObject, target, method, targetClass, arguments, advices);
            this.methodProxy = CglibAopProxy.isMethodProxyCompatible(method) ? methodProxy : null;
        }

        @Override
        protected Object invokeJoinPoint() throws Throwable {
            if (this.methodProxy != null) {
                try {
                    return this.methodProxy.invoke(this.target, this.args);
                }
                catch (CodeGenerationException ex) {
                    CglibAopProxy.logFastClassGenerationFailure(this.method);
                }
            }
            return super.invokeJoinPoint();
        }

        @Override
        public Object proceed() throws Throwable {
            try {
                return super.proceed();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (ReflectionUtils.declaresException((Method)this.getMethod(), ex.getClass())) {
                    throw ex;
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
    }
}

