/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.TargetClassAware;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.Advised;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.StandardProxy;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.core.DecoratingProxy;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AopProxyUtils {
    @Nullable
    public static Object getSingletonTarget(Object candidate) {
        TargetSource targetSource;
        if (candidate instanceof Advised && (targetSource = ((Advised)candidate).getTargetSource()) instanceof SingletonTargetSource) {
            return ((SingletonTargetSource)targetSource).getTarget();
        }
        return null;
    }

    public static Class<?> ultimateTargetClass(Object candidate) {
        Assert.notNull((Object)candidate, (String)"Candidate object must not be null");
        Object current = candidate;
        Class<?> result = null;
        while (current instanceof TargetClassAware) {
            result = ((TargetClassAware)current).getTargetClass();
            current = AopProxyUtils.getSingletonTarget(current);
        }
        if (result == null) {
            result = AopUtils.isCglibProxy(candidate) ? candidate.getClass().getSuperclass() : candidate.getClass();
        }
        return result;
    }

    public static Class<?>[] completeJdkProxyInterfaces(Class<?> ... userInterfaces) {
        ArrayList completedInterfaces = new ArrayList(userInterfaces.length + 3);
        for (Class<?> ifc : userInterfaces) {
            Assert.notNull(ifc, (String)"'userInterfaces' must not contain null values");
            Assert.isTrue((ifc.isInterface() && !ifc.isSealed() ? 1 : 0) != 0, () -> ifc.getName() + " must be a non-sealed interface");
            completedInterfaces.add(ifc);
        }
        completedInterfaces.add(StandardProxy.class);
        completedInterfaces.add(Advised.class);
        completedInterfaces.add(DecoratingProxy.class);
        return (Class[])completedInterfaces.toArray(Class[]::new);
    }

    public static Class<?>[] completeProxiedInterfaces(AdvisedSupport advised) {
        return AopProxyUtils.completeProxiedInterfaces(advised, false);
    }

    public static Class<?>[] completeProxiedInterfaces(AdvisedSupport advised, boolean decoratingProxy) {
        Class<?> targetClass;
        Class<?>[] specifiedInterfaces = advised.getProxiedInterfaces();
        if (specifiedInterfaces.length == 0 && (targetClass = advised.getTargetClass()) != null) {
            if (targetClass.isInterface()) {
                advised.setInterfaces(targetClass);
            } else if (Proxy.isProxyClass(targetClass) || ClassUtils.isLambdaClass(targetClass)) {
                advised.setInterfaces(targetClass.getInterfaces());
            }
            specifiedInterfaces = advised.getProxiedInterfaces();
        }
        ArrayList proxiedInterfaces = new ArrayList(specifiedInterfaces.length + 3);
        for (Class<?> ifc : specifiedInterfaces) {
            if (ifc.isSealed()) continue;
            proxiedInterfaces.add(ifc);
        }
        if (!advised.isInterfaceProxied(StandardProxy.class)) {
            proxiedInterfaces.add(StandardProxy.class);
        }
        if (!advised.isOpaque() && !advised.isInterfaceProxied(Advised.class)) {
            proxiedInterfaces.add(Advised.class);
        }
        if (decoratingProxy && !advised.isInterfaceProxied(DecoratingProxy.class)) {
            proxiedInterfaces.add(DecoratingProxy.class);
        }
        return ClassUtils.toClassArray(proxiedInterfaces);
    }

    public static Class<?>[] proxiedUserInterfaces(Object proxy) {
        Class<?>[] proxyInterfaces = proxy.getClass().getInterfaces();
        int nonUserIfcCount = 0;
        if (proxy instanceof StandardProxy) {
            ++nonUserIfcCount;
        }
        if (proxy instanceof Advised) {
            ++nonUserIfcCount;
        }
        if (proxy instanceof DecoratingProxy) {
            ++nonUserIfcCount;
        }
        Object[] userInterfaces = Arrays.copyOf(proxyInterfaces, proxyInterfaces.length - nonUserIfcCount);
        Assert.notEmpty((Object[])userInterfaces, (String)"JDK proxy must implement one or more interfaces");
        return userInterfaces;
    }

    public static boolean equalsInProxy(AdvisedSupport a, AdvisedSupport b) {
        return a == b || AopProxyUtils.equalsProxiedInterfaces(a, b) && AopProxyUtils.equalsAdvisors(a, b) && a.getTargetSource().equals(b.getTargetSource());
    }

    public static boolean equalsProxiedInterfaces(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getProxiedInterfaces(), b.getProxiedInterfaces());
    }

    public static boolean equalsAdvisors(AdvisedSupport a, AdvisedSupport b) {
        return a.getAdvisorCount() == b.getAdvisorCount() && Arrays.equals(a.getAdvisors(), b.getAdvisors());
    }
}

