/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.DefaultInterceptorChainFactory;
import cn.taketoday.aop.DynamicIntroductionAdvice;
import cn.taketoday.aop.InterceptorChainFactory;
import cn.taketoday.aop.IntroductionAdvisor;
import cn.taketoday.aop.IntroductionInfo;
import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.PointcutAdvisor;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.Advised;
import cn.taketoday.aop.framework.AopConfigException;
import cn.taketoday.aop.framework.ProxyConfig;
import cn.taketoday.aop.support.DefaultIntroductionAdvisor;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.aop.target.EmptyTargetSource;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;

public class AdvisedSupport
extends ProxyConfig
implements Advised {
    private static final long serialVersionUID = 1L;
    public static final TargetSource EMPTY_TARGET_SOURCE = EmptyTargetSource.INSTANCE;
    TargetSource targetSource = EMPTY_TARGET_SOURCE;
    private boolean preFiltered = false;
    private transient ConcurrentHashMap<MethodCacheKey, MethodInterceptor[]> methodCache;
    private ArrayList<Class<?>> interfaces = new ArrayList();
    private ArrayList<Advisor> advisors = new ArrayList();
    ArrayList<Advisor> advisorKey = this.advisors;
    private InterceptorChainFactory interceptorChainFactory = DefaultInterceptorChainFactory.INSTANCE;

    public AdvisedSupport() {
        this.methodCache = new ConcurrentHashMap(32);
    }

    public AdvisedSupport(Class<?> ... interfaces) {
        this();
        this.setInterfaces(interfaces);
    }

    private AdvisedSupport(InterceptorChainFactory chainFactory, ConcurrentHashMap<MethodCacheKey, MethodInterceptor[]> methodCache) {
        this.methodCache = methodCache;
        this.interceptorChainFactory = chainFactory;
    }

    public void setTarget(Object target) {
        this.setTargetSource(new SingletonTargetSource(target));
    }

    @Override
    public void setTargetSource(@Nullable TargetSource targetSource) {
        this.targetSource = targetSource != null ? targetSource : EMPTY_TARGET_SOURCE;
    }

    @Override
    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setInterceptorChainFactory(InterceptorChainFactory interceptorChainFactory) {
        Assert.notNull((Object)interceptorChainFactory, (String)"AdvisorChainFactory is required");
        this.interceptorChainFactory = interceptorChainFactory;
    }

    public InterceptorChainFactory getInterceptorChainFactory() {
        return this.interceptorChainFactory;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetSource = EmptyTargetSource.forClass(targetClass);
    }

    @Override
    @Nullable
    public Class<?> getTargetClass() {
        return this.targetSource.getTargetClass();
    }

    @Override
    public void setPreFiltered(boolean preFiltered) {
        this.preFiltered = preFiltered;
    }

    @Override
    public boolean isPreFiltered() {
        return this.preFiltered;
    }

    public void setInterfaces(Class<?> ... interfaces) {
        Assert.notNull(interfaces, (String)"Interfaces is required");
        this.interfaces.clear();
        for (Class<?> ifc : interfaces) {
            this.addInterface(ifc);
        }
    }

    public void addInterface(Class<?> intf) {
        Assert.notNull(intf, (String)"Interface is required");
        if (!intf.isInterface()) {
            throw new IllegalArgumentException("[" + intf.getName() + "] is not an interface");
        }
        if (!this.interfaces.contains(intf)) {
            this.interfaces.add(intf);
            this.adviceChanged();
        }
    }

    public boolean removeInterface(Class<?> intf) {
        return this.interfaces.remove(intf);
    }

    @Override
    public Class<?>[] getProxiedInterfaces() {
        return ClassUtils.toClassArray(this.interfaces);
    }

    @Override
    public boolean isInterfaceProxied(Class<?> intf) {
        for (Class<?> proxyIntf : this.interfaces) {
            if (!intf.isAssignableFrom(proxyIntf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Advisor[] getAdvisors() {
        return this.advisors.toArray(new Advisor[0]);
    }

    @Override
    public int getAdvisorCount() {
        return this.advisors.size();
    }

    @Override
    public void addAdvisor(Advisor advisor) {
        int pos = this.advisors.size();
        this.addAdvisor(pos, advisor);
    }

    @Override
    public void addAdvisor(int pos, Advisor advisor) {
        if (advisor instanceof IntroductionAdvisor) {
            this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
        }
        this.addAdvisorInternal(pos, advisor);
    }

    @Override
    public boolean removeAdvisor(Advisor advisor) {
        int index = this.indexOf(advisor);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    @Override
    public void removeAdvisor(int index) {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot remove Advisor: Configuration is frozen.");
        }
        if (index < 0 || index > this.advisors.size() - 1) {
            throw new AopConfigException("Advisor index " + index + " is out of bounds: This configuration only has " + this.advisors.size() + " advisors.");
        }
        Advisor advisor = this.advisors.remove(index);
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            for (Class<?> ifc : ia.getInterfaces()) {
                this.removeInterface(ifc);
            }
        }
        this.adviceChanged();
    }

    @Override
    public int indexOf(Advisor advisor) {
        Assert.notNull((Object)advisor, (String)"Advisor is required");
        return this.advisors.indexOf(advisor);
    }

    @Override
    public boolean replaceAdvisor(Advisor a, Advisor b) throws AopConfigException {
        Assert.notNull((Object)a, (String)"Advisor 'a' is required");
        Assert.notNull((Object)b, (String)"Advisor 'b' is required");
        int index = this.indexOf(a);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        this.addAdvisor(index, b);
        return true;
    }

    public void addAdvisors(Advisor ... advisors) {
        this.addAdvisors(Arrays.asList(advisors));
    }

    public void addAdvisors(Collection<Advisor> advisors) {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: Configuration is frozen.");
        }
        if (CollectionUtils.isNotEmpty(advisors)) {
            for (Advisor advisor : advisors) {
                Assert.notNull((Object)advisor, (String)"Advisor is required");
                if (advisor instanceof IntroductionAdvisor) {
                    this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
                }
                this.advisors.add(advisor);
            }
            this.adviceChanged();
        }
    }

    private void validateIntroductionAdvisor(IntroductionAdvisor advisor) {
        Class<?>[] ifcs;
        advisor.validateInterfaces();
        for (Class<?> ifc : ifcs = advisor.getInterfaces()) {
            this.addInterface(ifc);
        }
    }

    void addAdvisorInternal(int pos, Advisor advisor) throws AopConfigException {
        Assert.notNull((Object)advisor, (String)"Advisor is required");
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: Configuration is frozen.");
        }
        if (pos > this.advisors.size()) {
            throw new IllegalArgumentException("Illegal position " + pos + " in advisor list with size " + this.advisors.size());
        }
        this.advisors.add(pos, advisor);
        this.adviceChanged();
    }

    protected final List<Advisor> getAdvisorsInternal() {
        return this.advisors;
    }

    @Override
    public void addAdvice(Advice advice) throws AopConfigException {
        int pos = this.advisors.size();
        this.addAdvice(pos, advice);
    }

    @Override
    public void addAdvice(int pos, Advice advice) throws AopConfigException {
        Assert.notNull((Object)advice, (String)"Advice is required");
        if (advice instanceof IntroductionInfo) {
            this.addAdvisor(pos, new DefaultIntroductionAdvisor(advice, (IntroductionInfo)((Object)advice)));
        } else {
            if (advice instanceof DynamicIntroductionAdvice) {
                throw new AopConfigException("DynamicIntroductionAdvice may only be added as part of IntroductionAdvisor");
            }
            this.addAdvisor(pos, new DefaultPointcutAdvisor(advice));
        }
    }

    @Override
    public boolean removeAdvice(Advice advice) throws AopConfigException {
        int index = this.indexOf(advice);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    @Override
    public int indexOf(Advice advice) {
        Assert.notNull((Object)advice, (String)"Advice is required");
        ArrayList<Advisor> advisors = this.advisors;
        for (int i = 0; i < advisors.size(); ++i) {
            Advisor advisor = advisors.get(i);
            if (advisor.getAdvice() != advice) continue;
            return i;
        }
        return -1;
    }

    public boolean adviceIncluded(@Nullable Advice advice) {
        if (advice != null) {
            for (Advisor advisor : this.advisors) {
                if (advisor.getAdvice() != advice) continue;
                return true;
            }
        }
        return false;
    }

    public int countAdvicesOfType(@Nullable Class<?> adviceClass) {
        int count = 0;
        if (adviceClass != null) {
            for (Advisor advisor : this.advisors) {
                if (!adviceClass.isInstance(advisor.getAdvice())) continue;
                ++count;
            }
        }
        return count;
    }

    public MethodInterceptor[] getInterceptors(Method method, @Nullable Class<?> targetClass) {
        MethodCacheKey cacheKey = new MethodCacheKey(method);
        MethodInterceptor[] cached = this.methodCache.get(cacheKey);
        if (cached == null) {
            cached = this.interceptorChainFactory.getInterceptors(this, method, targetClass);
            this.methodCache.put(cacheKey, cached);
        }
        return cached;
    }

    protected void adviceChanged() {
        this.methodCache.clear();
    }

    protected void copyConfigurationFrom(AdvisedSupport other) {
        this.copyConfigurationFrom(other, other.targetSource, new ArrayList<Advisor>(other.advisors));
    }

    protected void copyConfigurationFrom(AdvisedSupport other, TargetSource targetSource, List<Advisor> advisors) {
        this.copyFrom(other);
        this.targetSource = targetSource;
        this.interceptorChainFactory = other.interceptorChainFactory;
        this.interfaces = new ArrayList(other.interfaces);
        for (Advisor advisor : advisors) {
            Assert.notNull((Object)advisor, (String)"Advisor is required");
            if (advisor instanceof IntroductionAdvisor) {
                this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
            }
            this.advisors.add(advisor);
        }
        this.adviceChanged();
    }

    AdvisedSupport getConfigurationOnlyCopy() {
        AdvisedSupport copy = new AdvisedSupport(this.interceptorChainFactory, this.methodCache);
        copy.copyFrom(this);
        copy.targetSource = EmptyTargetSource.forClass(this.getTargetClass(), this.getTargetSource().isStatic());
        copy.interfaces = new ArrayList(this.interfaces);
        copy.advisors = new ArrayList<Advisor>(this.advisors);
        copy.advisorKey = new ArrayList(this.advisors.size());
        for (Advisor advisor : this.advisors) {
            copy.advisorKey.add(new AdvisorKeyEntry(advisor));
        }
        return copy;
    }

    void reduceToAdvisorKey() {
        this.advisors = this.advisorKey;
        this.methodCache.clear();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.methodCache = new ConcurrentHashMap(32);
    }

    @Override
    public String toProxyConfigString() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(": ").append(this.interfaces.size()).append(" interfaces ");
        sb.append(ClassUtils.classNamesToString(this.interfaces)).append("; ");
        sb.append(this.advisors.size()).append(" advisors ");
        sb.append(this.advisors).append("; ");
        sb.append("targetSource [").append(this.targetSource).append("]; ");
        sb.append(super.toString());
        return sb.toString();
    }

    static final class MethodCacheKey
    implements Comparable<MethodCacheKey> {
        private final int hashCode;
        private final Method method;

        public MethodCacheKey(Method method) {
            this.method = method;
            this.hashCode = method.hashCode();
        }

        public boolean equals(Object other) {
            return this == other || other instanceof MethodCacheKey && this.method == ((MethodCacheKey)other).method;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.method.toString();
        }

        @Override
        public int compareTo(MethodCacheKey other) {
            int result = this.method.getName().compareTo(other.method.getName());
            if (result == 0) {
                result = this.method.toString().compareTo(other.method.toString());
            }
            return result;
        }
    }

    private static class AdvisorKeyEntry
    implements Advisor {
        private final Class<?> adviceType;
        @Nullable
        private final String classFilterKey;
        @Nullable
        private final String methodMatcherKey;

        public AdvisorKeyEntry(Advisor advisor) {
            this.adviceType = advisor.getAdvice().getClass();
            if (advisor instanceof PointcutAdvisor) {
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                Pointcut pointcut = pointcutAdvisor.getPointcut();
                this.classFilterKey = pointcut.getClassFilter().toString();
                this.methodMatcherKey = pointcut.getMethodMatcher().toString();
            } else {
                this.classFilterKey = null;
                this.methodMatcherKey = null;
            }
        }

        @Override
        public Advice getAdvice() {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof AdvisorKeyEntry)) return false;
            AdvisorKeyEntry otherEntry = (AdvisorKeyEntry)other;
            if (this.adviceType != otherEntry.adviceType) return false;
            if (!Objects.equals(this.classFilterKey, otherEntry.classFilterKey)) return false;
            if (!Objects.equals(this.methodMatcherKey, otherEntry.methodMatcherKey)) return false;
            return true;
        }

        public int hashCode() {
            return this.adviceType.hashCode();
        }
    }
}

