/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.AopInfrastructureBean;
import cn.taketoday.aop.framework.Advised;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.ProxyFactory;
import cn.taketoday.aop.framework.ProxyProcessorSupport;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import cn.taketoday.core.SmartClassLoader;
import cn.taketoday.lang.Nullable;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractAdvisingBeanPostProcessor
extends ProxyProcessorSupport
implements InitializationBeanPostProcessor,
SmartInstantiationAwareBeanPostProcessor {
    private static final long serialVersionUID = 1L;
    @Nullable
    protected Advisor advisor;
    protected boolean beforeExistingAdvisors = false;
    private final ConcurrentHashMap<Class<?>, Boolean> eligibleBeans = new ConcurrentHashMap(256);

    public void setBeforeExistingAdvisors(boolean beforeExistingAdvisors) {
        this.beforeExistingAdvisors = beforeExistingAdvisors;
    }

    public Class<?> determineBeanType(Class<?> beanClass, String beanName) {
        if (this.advisor != null && this.isEligible(beanClass)) {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.copyFrom(this);
            proxyFactory.setTargetClass(beanClass);
            if (!proxyFactory.isProxyTargetClass()) {
                this.evaluateProxyInterfaces(beanClass, proxyFactory);
            }
            proxyFactory.addAdvisor(this.advisor);
            this.customizeProxyFactory(proxyFactory);
            ClassLoader classLoader = this.getProxyClassLoader();
            if (classLoader instanceof SmartClassLoader) {
                SmartClassLoader smartClassLoader = (SmartClassLoader)classLoader;
                if (classLoader != beanClass.getClassLoader()) {
                    classLoader = smartClassLoader.getOriginalClassLoader();
                }
            }
            return proxyFactory.getProxyClass(classLoader);
        }
        return beanClass;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Advised advised;
        if (this.advisor == null || bean instanceof AopInfrastructureBean) {
            return bean;
        }
        if (bean instanceof Advised && !(advised = (Advised)bean).isFrozen() && this.isEligible(AopUtils.getTargetClass(bean))) {
            if (this.beforeExistingAdvisors) {
                advised.addAdvisor(0, this.advisor);
            } else {
                if (advised.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE && advised.getAdvisorCount() > 0) {
                    advised.addAdvisor(advised.getAdvisorCount() - 1, this.advisor);
                    return bean;
                }
                advised.addAdvisor(this.advisor);
            }
            return bean;
        }
        if (this.isEligible(bean, beanName)) {
            ProxyFactory proxyFactory = this.prepareProxyFactory(bean, beanName);
            if (!proxyFactory.isProxyTargetClass()) {
                this.evaluateProxyInterfaces(bean.getClass(), proxyFactory);
            }
            proxyFactory.addAdvisor(this.advisor);
            this.customizeProxyFactory(proxyFactory);
            ClassLoader classLoader = this.getProxyClassLoader();
            if (classLoader instanceof SmartClassLoader && classLoader != bean.getClass().getClassLoader()) {
                classLoader = ((SmartClassLoader)classLoader).getOriginalClassLoader();
            }
            return proxyFactory.getProxy(classLoader);
        }
        return bean;
    }

    protected boolean isEligible(Object bean, String beanName) {
        return this.isEligible(bean.getClass());
    }

    protected boolean isEligible(Class<?> targetClass) {
        Boolean eligible = this.eligibleBeans.get(targetClass);
        if (eligible != null) {
            return eligible;
        }
        if (this.advisor == null) {
            return false;
        }
        eligible = AopUtils.canApply(this.advisor, targetClass);
        this.eligibleBeans.put(targetClass, eligible);
        return eligible;
    }

    protected ProxyFactory prepareProxyFactory(Object bean, String beanName) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.copyFrom(this);
        proxyFactory.setTarget(bean);
        return proxyFactory;
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
    }
}

