/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.config;

import cn.taketoday.aop.scope.ScopedProxyUtils;
import cn.taketoday.beans.factory.config.BeanDefinitionHolder;
import cn.taketoday.beans.factory.parsing.BeanComponentDefinition;
import cn.taketoday.beans.factory.parsing.ComponentDefinition;
import cn.taketoday.beans.factory.xml.BeanDefinitionDecorator;
import cn.taketoday.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ScopedProxyBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    private static final String PROXY_TARGET_CLASS = "proxy-target-class";

    ScopedProxyBeanDefinitionDecorator() {
    }

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        Element ele;
        boolean proxyTargetClass = true;
        if (node instanceof Element && (ele = (Element)node).hasAttribute(PROXY_TARGET_CLASS)) {
            proxyTargetClass = Boolean.parseBoolean(ele.getAttribute(PROXY_TARGET_CLASS));
        }
        BeanDefinitionHolder holder = ScopedProxyUtils.createScopedProxy(definition, parserContext.getRegistry(), proxyTargetClass);
        String targetBeanName = ScopedProxyUtils.getTargetBeanName(definition.getBeanName());
        parserContext.getReaderContext().fireComponentRegistered((ComponentDefinition)new BeanComponentDefinition(definition.getBeanDefinition(), targetBeanName));
        return holder;
    }
}

