/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.aspectj.autoproxy;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.aspectj.AbstractAspectJAdvice;
import cn.taketoday.aop.aspectj.AspectJPointcutAdvisor;
import cn.taketoday.aop.aspectj.AspectJProxyUtils;
import cn.taketoday.aop.aspectj.autoproxy.AspectJPrecedenceComparator;
import cn.taketoday.aop.framework.autoproxy.AbstractAdvisorAutoProxyCreator;
import cn.taketoday.core.Ordered;
import cn.taketoday.util.ClassUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aspectj.util.PartialOrder;

public class AspectJAwareAdvisorAutoProxyCreator
extends AbstractAdvisorAutoProxyCreator {
    private static final Comparator<Advisor> DEFAULT_PRECEDENCE_COMPARATOR = new AspectJPrecedenceComparator();

    @Override
    protected List<Advisor> sortAdvisors(List<Advisor> advisors) {
        ArrayList<PartiallyComparableAdvisorHolder> partiallyComparableAdvisors = new ArrayList<PartiallyComparableAdvisorHolder>(advisors.size());
        for (Advisor advisor : advisors) {
            partiallyComparableAdvisors.add(new PartiallyComparableAdvisorHolder(advisor, DEFAULT_PRECEDENCE_COMPARATOR));
        }
        List sorted = PartialOrder.sort(partiallyComparableAdvisors);
        if (sorted != null) {
            ArrayList<Advisor> result = new ArrayList<Advisor>(advisors.size());
            for (PartiallyComparableAdvisorHolder pcAdvisor : sorted) {
                result.add(pcAdvisor.getAdvisor());
            }
            return result;
        }
        return super.sortAdvisors(advisors);
    }

    @Override
    protected void extendAdvisors(List<Advisor> candidateAdvisors) {
        AspectJProxyUtils.makeAdvisorChainAspectJCapableIfNecessary(candidateAdvisors);
    }

    @Override
    protected boolean shouldSkip(Class<?> beanClass, String beanName) {
        List<Advisor> candidateAdvisors = this.findCandidateAdvisors();
        for (Advisor advisor : candidateAdvisors) {
            AspectJPointcutAdvisor pointcutAdvisor;
            if (!(advisor instanceof AspectJPointcutAdvisor) || !(pointcutAdvisor = (AspectJPointcutAdvisor)advisor).getAspectName().equals(beanName)) continue;
            return true;
        }
        return super.shouldSkip(beanClass, beanName);
    }

    private record PartiallyComparableAdvisorHolder(Advisor advisor, Comparator<Advisor> comparator) implements PartialOrder.PartialComparable
    {
        public int compareTo(Object obj) {
            Advisor otherAdvisor = ((PartiallyComparableAdvisorHolder)obj).advisor;
            return this.comparator.compare(this.advisor, otherAdvisor);
        }

        public int fallbackCompareTo(Object obj) {
            return 0;
        }

        public Advisor getAdvisor() {
            return this.advisor;
        }

        @Override
        public String toString() {
            Advice advice = this.advisor.getAdvice();
            StringBuilder sb = new StringBuilder(ClassUtils.getShortName(advice.getClass()));
            boolean appended = false;
            if (this.advisor instanceof Ordered) {
                sb.append(": order = ").append(((Ordered)this.advisor).getOrder());
                appended = true;
            }
            if (advice instanceof AbstractAspectJAdvice) {
                AbstractAspectJAdvice ajAdvice = (AbstractAspectJAdvice)advice;
                sb.append(!appended ? ": " : ", ");
                sb.append("aspect name = ");
                sb.append(ajAdvice.getAspectName());
                sb.append(", declaration order = ");
                sb.append(ajAdvice.getDeclarationOrder());
            }
            return sb.toString();
        }
    }
}

