/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.aspectj.annotation;

import cn.taketoday.aop.aspectj.SingletonAspectInstanceFactory;
import cn.taketoday.aop.aspectj.annotation.AspectMetadata;
import cn.taketoday.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import cn.taketoday.core.annotation.OrderUtils;
import java.io.Serializable;

public class SingletonMetadataAwareAspectInstanceFactory
extends SingletonAspectInstanceFactory
implements MetadataAwareAspectInstanceFactory,
Serializable {
    private final AspectMetadata metadata;

    public SingletonMetadataAwareAspectInstanceFactory(Object aspectInstance, String aspectName) {
        super(aspectInstance);
        this.metadata = new AspectMetadata(aspectInstance.getClass(), aspectName);
    }

    @Override
    public final AspectMetadata getAspectMetadata() {
        return this.metadata;
    }

    @Override
    public Object getAspectCreationMutex() {
        return this;
    }

    @Override
    protected int getOrderForAspectClass(Class<?> aspectClass) {
        return OrderUtils.getOrder(aspectClass, (int)Integer.MAX_VALUE);
    }
}

