/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.aspectj.annotation;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.aspectj.AbstractAspectJAdvice;
import cn.taketoday.aop.aspectj.AspectJAfterAdvice;
import cn.taketoday.aop.aspectj.AspectJAfterReturningAdvice;
import cn.taketoday.aop.aspectj.AspectJAfterThrowingAdvice;
import cn.taketoday.aop.aspectj.AspectJAroundAdvice;
import cn.taketoday.aop.aspectj.AspectJExpressionPointcut;
import cn.taketoday.aop.aspectj.AspectJMethodBeforeAdvice;
import cn.taketoday.aop.aspectj.DeclareParentsAdvisor;
import cn.taketoday.aop.aspectj.annotation.AbstractAspectJAdvisorFactory;
import cn.taketoday.aop.aspectj.annotation.InstantiationModelAwarePointcutAdvisorImpl;
import cn.taketoday.aop.aspectj.annotation.LazySingletonAspectInstanceFactoryDecorator;
import cn.taketoday.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import cn.taketoday.aop.framework.AopConfigException;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.conversion.ConvertingComparator;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import cn.taketoday.util.comparator.InstanceComparator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.DeclareParents;
import org.aspectj.lang.annotation.Pointcut;

public class ReflectiveAspectJAdvisorFactory
extends AbstractAspectJAdvisorFactory
implements Serializable {
    private static final ReflectionUtils.MethodFilter adviceMethodFilter = ReflectionUtils.USER_DECLARED_METHODS.and(method -> AnnotationUtils.getAnnotation((Method)method, Pointcut.class) == null);
    private static final Comparator<Method> adviceMethodComparator;
    @Nullable
    private final BeanFactory beanFactory;

    public ReflectiveAspectJAdvisorFactory() {
        this(null);
    }

    public ReflectiveAspectJAdvisorFactory(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public List<Advisor> getAdvisors(MetadataAwareAspectInstanceFactory aspectInstanceFactory) {
        Class<?> aspectClass = aspectInstanceFactory.getAspectMetadata().getAspectClass();
        String aspectName = aspectInstanceFactory.getAspectMetadata().getAspectName();
        this.validate(aspectClass);
        LazySingletonAspectInstanceFactoryDecorator factory = new LazySingletonAspectInstanceFactoryDecorator(aspectInstanceFactory);
        ArrayList<Advisor> advisors = new ArrayList<Advisor>();
        for (Method method : this.getAdvisorMethods(aspectClass)) {
            Advisor advisor = this.getAdvisor(method, factory, 0, aspectName);
            if (advisor == null) continue;
            advisors.add(advisor);
        }
        if (!advisors.isEmpty() && factory.getAspectMetadata().isLazilyInstantiated()) {
            SyntheticInstantiationAdvisor instantiationAdvisor = new SyntheticInstantiationAdvisor(factory);
            advisors.add(0, instantiationAdvisor);
        }
        for (Field field : aspectClass.getDeclaredFields()) {
            Advisor advisor = this.getDeclareParentsAdvisor(field);
            if (advisor == null) continue;
            advisors.add(advisor);
        }
        return advisors;
    }

    private List<Method> getAdvisorMethods(Class<?> aspectClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ReflectionUtils.doWithMethods(aspectClass, methods::add, (ReflectionUtils.MethodFilter)adviceMethodFilter);
        if (methods.size() > 1) {
            methods.sort(adviceMethodComparator);
        }
        return methods;
    }

    @Nullable
    private Advisor getDeclareParentsAdvisor(Field introductionField) {
        DeclareParents declareParents = introductionField.getAnnotation(DeclareParents.class);
        if (declareParents == null) {
            return null;
        }
        if (DeclareParents.class == declareParents.defaultImpl()) {
            throw new IllegalStateException("'defaultImpl' attribute must be set on DeclareParents");
        }
        return new DeclareParentsAdvisor(introductionField.getType(), declareParents.value(), declareParents.defaultImpl());
    }

    @Override
    @Nullable
    public Advisor getAdvisor(Method candidateAdviceMethod, MetadataAwareAspectInstanceFactory aspectInstanceFactory, int declarationOrderInAspect, String aspectName) {
        this.validate(aspectInstanceFactory.getAspectMetadata().getAspectClass());
        AspectJExpressionPointcut expressionPointcut = this.getPointcut(candidateAdviceMethod, aspectInstanceFactory.getAspectMetadata().getAspectClass());
        if (expressionPointcut == null) {
            return null;
        }
        return new InstantiationModelAwarePointcutAdvisorImpl(expressionPointcut, candidateAdviceMethod, this, aspectInstanceFactory, declarationOrderInAspect, aspectName);
    }

    @Nullable
    private AspectJExpressionPointcut getPointcut(Method candidateAdviceMethod, Class<?> candidateAspectClass) {
        AbstractAspectJAdvisorFactory.AspectJAnnotation<?> aspectJAnnotation = ReflectiveAspectJAdvisorFactory.findAspectJAnnotationOnMethod(candidateAdviceMethod);
        if (aspectJAnnotation == null) {
            return null;
        }
        AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut(candidateAspectClass, new String[0], new Class[0]);
        ajexp.setExpression(aspectJAnnotation.getPointcutExpression());
        if (this.beanFactory != null) {
            ajexp.setBeanFactory(this.beanFactory);
        }
        return ajexp;
    }

    @Override
    @Nullable
    public Advice getAdvice(Method candidateAdviceMethod, AspectJExpressionPointcut expressionPointcut, MetadataAwareAspectInstanceFactory aspectFactory, int declarationOrder, String aspectName) {
        AbstractAspectJAdvice advice;
        Class<?> candidateAspectClass = aspectFactory.getAspectMetadata().getAspectClass();
        this.validate(candidateAspectClass);
        AbstractAspectJAdvisorFactory.AspectJAnnotation<?> aspectJAnnotation = ReflectiveAspectJAdvisorFactory.findAspectJAnnotationOnMethod(candidateAdviceMethod);
        if (aspectJAnnotation == null) {
            return null;
        }
        if (!this.isAspect(candidateAspectClass)) {
            throw new AopConfigException("Advice must be declared inside an aspect type: Offending method '" + candidateAdviceMethod + "' in class [" + candidateAspectClass.getName() + "]");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found AspectJ method: {}", (Object)candidateAdviceMethod);
        }
        switch (aspectJAnnotation.getAnnotationType()) {
            case AtPointcut: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Processing pointcut '{}'", (Object)candidateAdviceMethod.getName());
                }
                return null;
            }
            case AtAfter: {
                advice = new AspectJAfterAdvice(candidateAdviceMethod, expressionPointcut, aspectFactory);
                break;
            }
            case AtAround: {
                advice = new AspectJAroundAdvice(candidateAdviceMethod, expressionPointcut, aspectFactory);
                break;
            }
            case AtBefore: {
                advice = new AspectJMethodBeforeAdvice(candidateAdviceMethod, expressionPointcut, aspectFactory);
                break;
            }
            case AtAfterReturning: {
                advice = new AspectJAfterReturningAdvice(candidateAdviceMethod, expressionPointcut, aspectFactory);
                AfterReturning afterReturningAnnotation = (AfterReturning)aspectJAnnotation.getAnnotation();
                if (!StringUtils.hasText((String)afterReturningAnnotation.returning())) break;
                advice.setReturningName(afterReturningAnnotation.returning());
                break;
            }
            case AtAfterThrowing: {
                advice = new AspectJAfterThrowingAdvice(candidateAdviceMethod, expressionPointcut, aspectFactory);
                AfterThrowing afterThrowingAnnotation = (AfterThrowing)aspectJAnnotation.getAnnotation();
                if (!StringUtils.hasText((String)afterThrowingAnnotation.throwing())) break;
                advice.setThrowingName(afterThrowingAnnotation.throwing());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported advice type on method: " + candidateAdviceMethod);
            }
        }
        advice.setAspectName(aspectName);
        advice.setDeclarationOrder(declarationOrder);
        String[] argNames = this.parameterNameDiscoverer.getParameterNames((Executable)candidateAdviceMethod);
        if (argNames != null) {
            advice.setArgumentNamesFromStringArray(argNames);
        }
        advice.calculateArgumentBindings();
        return advice;
    }

    static {
        ConvertingComparator adviceKindComparator = new ConvertingComparator((Comparator)new InstanceComparator(new Class[]{Around.class, Before.class, After.class, AfterReturning.class, AfterThrowing.class}), method -> {
            AbstractAspectJAdvisorFactory.AspectJAnnotation<?> ann = ReflectiveAspectJAdvisorFactory.findAspectJAnnotationOnMethod(method);
            return ann != null ? (Annotation)ann.getAnnotation() : null;
        });
        ConvertingComparator methodNameComparator = new ConvertingComparator(Method::getName);
        adviceMethodComparator = adviceKindComparator.thenComparing(methodNameComparator);
    }

    protected static class SyntheticInstantiationAdvisor
    extends DefaultPointcutAdvisor {
        public SyntheticInstantiationAdvisor(MetadataAwareAspectInstanceFactory aif) {
            super(aif.getAspectMetadata().getPerClausePointcut(), inv -> aif.getAspectInstance());
        }
    }
}

