/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.aspectj.annotation;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.aspectj.AspectJProxyUtils;
import cn.taketoday.aop.aspectj.SimpleAspectInstanceFactory;
import cn.taketoday.aop.aspectj.annotation.AspectJAdvisorFactory;
import cn.taketoday.aop.aspectj.annotation.AspectMetadata;
import cn.taketoday.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import cn.taketoday.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import cn.taketoday.aop.aspectj.annotation.SimpleMetadataAwareAspectInstanceFactory;
import cn.taketoday.aop.aspectj.annotation.SingletonMetadataAwareAspectInstanceFactory;
import cn.taketoday.aop.framework.ProxyCreatorSupport;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.reflect.PerClauseKind;

public class AspectJProxyFactory
extends ProxyCreatorSupport {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentHashMap<Class<?>, Object> aspectCache = new ConcurrentHashMap();
    private final AspectJAdvisorFactory aspectFactory = new ReflectiveAspectJAdvisorFactory();

    public AspectJProxyFactory() {
    }

    public AspectJProxyFactory(Object target) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        this.setInterfaces(ClassUtils.getAllInterfaces((Object)target));
        this.setTarget(target);
    }

    public AspectJProxyFactory(Class<?> ... interfaces) {
        this.setInterfaces(interfaces);
    }

    public void addAspect(Object aspectInstance) {
        String aspectName;
        Class<?> aspectClass = aspectInstance.getClass();
        AspectMetadata am = this.createAspectMetadata(aspectClass, aspectName = aspectClass.getName());
        if (am.getAjType().getPerClause().getKind() != PerClauseKind.SINGLETON) {
            throw new IllegalArgumentException("Aspect class [" + aspectClass.getName() + "] does not define a singleton aspect");
        }
        this.addAdvisorsFromAspectInstanceFactory(new SingletonMetadataAwareAspectInstanceFactory(aspectInstance, aspectName));
    }

    public void addAspect(Class<?> aspectClass) {
        String aspectName = aspectClass.getName();
        AspectMetadata am = this.createAspectMetadata(aspectClass, aspectName);
        MetadataAwareAspectInstanceFactory instanceFactory = this.createAspectInstanceFactory(am, aspectClass, aspectName);
        this.addAdvisorsFromAspectInstanceFactory(instanceFactory);
    }

    private void addAdvisorsFromAspectInstanceFactory(MetadataAwareAspectInstanceFactory instanceFactory) {
        List<Advisor> advisors = this.aspectFactory.getAdvisors(instanceFactory);
        Class<?> targetClass = this.getTargetClass();
        Assert.state((targetClass != null ? 1 : 0) != 0, (String)"Unresolvable target class");
        advisors = AopUtils.filterAdvisors(advisors, targetClass);
        AspectJProxyUtils.makeAdvisorChainAspectJCapableIfNecessary(advisors);
        AnnotationAwareOrderComparator.sort(advisors);
        this.addAdvisors(advisors);
    }

    private AspectMetadata createAspectMetadata(Class<?> aspectClass, String aspectName) {
        return new AspectMetadata(aspectClass, aspectName);
    }

    private MetadataAwareAspectInstanceFactory createAspectInstanceFactory(AspectMetadata am, Class<?> aspectClass, String aspectName) {
        MetadataAwareAspectInstanceFactory instanceFactory;
        if (am.getAjType().getPerClause().getKind() == PerClauseKind.SINGLETON) {
            Object instance = this.getSingletonAspectInstance(aspectClass);
            instanceFactory = new SingletonMetadataAwareAspectInstanceFactory(instance, aspectName);
        } else {
            instanceFactory = new SimpleMetadataAwareAspectInstanceFactory(aspectClass, aspectName);
        }
        return instanceFactory;
    }

    private Object getSingletonAspectInstance(Class<?> aspectClass) {
        return aspectCache.computeIfAbsent(aspectClass, clazz -> new SimpleAspectInstanceFactory((Class<?>)clazz).getAspectInstance());
    }

    public <T> T getProxy() {
        return (T)this.createAopProxy().getProxy();
    }

    public <T> T getProxy(@Nullable ClassLoader classLoader) {
        return (T)this.createAopProxy().getProxy(classLoader);
    }
}

