/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.aspectj.annotation;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.aspectj.AbstractAspectJAdvice;
import cn.taketoday.aop.aspectj.annotation.BeanFactoryAspectJAdvisorsBuilder;
import cn.taketoday.aot.generate.GenerationContext;
import cn.taketoday.aot.hint.ExecutableMode;
import cn.taketoday.aot.hint.ReflectionHints;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.aot.BeanFactoryInitializationAotContribution;
import cn.taketoday.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import cn.taketoday.beans.factory.aot.BeanFactoryInitializationCode;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.util.List;
import org.aopalliance.aop.Advice;

class AspectJBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final boolean aspectJPresent = ClassUtils.isPresent((String)"org.aspectj.lang.annotation.Pointcut", (ClassLoader)AspectJBeanFactoryInitializationAotProcessor.class.getClassLoader());

    AspectJBeanFactoryInitializationAotProcessor() {
    }

    @Nullable
    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableBeanFactory beanFactory) {
        if (aspectJPresent) {
            return AspectDelegate.processAheadOfTime(beanFactory);
        }
        return null;
    }

    private static class AspectDelegate {
        private AspectDelegate() {
        }

        @Nullable
        private static AspectContribution processAheadOfTime(ConfigurableBeanFactory beanFactory) {
            BeanFactoryAspectJAdvisorsBuilder builder = new BeanFactoryAspectJAdvisorsBuilder((BeanFactory)beanFactory);
            List<Advisor> advisors = builder.buildAspectJAdvisors();
            return advisors.isEmpty() ? null : new AspectContribution(advisors);
        }
    }

    private static class AspectContribution
    implements BeanFactoryInitializationAotContribution {
        private final List<Advisor> advisors;

        public AspectContribution(List<Advisor> advisors) {
            this.advisors = advisors;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            ReflectionHints reflectionHints = generationContext.getRuntimeHints().reflection();
            for (Advisor advisor : this.advisors) {
                Advice advice = advisor.getAdvice();
                if (!(advice instanceof AbstractAspectJAdvice)) continue;
                AbstractAspectJAdvice aspectJAdvice = (AbstractAspectJAdvice)advice;
                reflectionHints.registerMethod(aspectJAdvice.getAspectJAdviceMethod(), ExecutableMode.INVOKE);
            }
        }
    }
}

