/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.aspectj;

import cn.taketoday.aop.ClassFilter;
import cn.taketoday.aop.IntroductionAdvisor;
import cn.taketoday.aop.IntroductionInterceptor;
import cn.taketoday.aop.aspectj.TypePatternClassFilter;
import cn.taketoday.aop.support.DelegatePerTargetObjectIntroductionInterceptor;
import cn.taketoday.aop.support.DelegatingIntroductionInterceptor;
import org.aopalliance.aop.Advice;

public class DeclareParentsAdvisor
implements IntroductionAdvisor {
    private final Advice advice;
    private final Class<?> introducedInterface;
    private final ClassFilter typePatternClassFilter;

    public DeclareParentsAdvisor(Class<?> interfaceType, String typePattern, Class<?> defaultImpl) {
        this(interfaceType, typePattern, new DelegatePerTargetObjectIntroductionInterceptor(defaultImpl, interfaceType));
    }

    public DeclareParentsAdvisor(Class<?> interfaceType, String typePattern, Object delegateRef) {
        this(interfaceType, typePattern, new DelegatingIntroductionInterceptor(delegateRef));
    }

    private DeclareParentsAdvisor(Class<?> interfaceType, String typePattern, IntroductionInterceptor interceptor) {
        this.advice = interceptor;
        this.introducedInterface = interfaceType;
        TypePatternClassFilter typePatternFilter = new TypePatternClassFilter(typePattern);
        ClassFilter exclusion = clazz -> !this.introducedInterface.isAssignableFrom(clazz);
        this.typePatternClassFilter = ClassFilter.intersection(typePatternFilter, exclusion);
    }

    @Override
    public ClassFilter getClassFilter() {
        return this.typePatternClassFilter;
    }

    @Override
    public void validateInterfaces() throws IllegalArgumentException {
    }

    @Override
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public Class<?>[] getInterfaces() {
        return new Class[]{this.introducedInterface};
    }
}

