/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.aspectj;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.PointcutAdvisor;
import cn.taketoday.aop.aspectj.AbstractAspectJAdvice;
import cn.taketoday.aop.aspectj.AspectJExpressionPointcut;
import cn.taketoday.aop.aspectj.InstantiationModelAwarePointcutAdvisor;
import cn.taketoday.aop.interceptor.ExposeInvocationInterceptor;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import java.util.List;

public abstract class AspectJProxyUtils {
    public static boolean makeAdvisorChainAspectJCapableIfNecessary(List<Advisor> advisors) {
        if (!advisors.isEmpty()) {
            boolean foundAspectJAdvice = false;
            for (Advisor advisor : advisors) {
                if (!AspectJProxyUtils.isAspectJAdvice(advisor)) continue;
                foundAspectJAdvice = true;
                break;
            }
            if (foundAspectJAdvice && !advisors.contains(ExposeInvocationInterceptor.ADVISOR)) {
                advisors.add(0, ExposeInvocationInterceptor.ADVISOR);
                return true;
            }
        }
        return false;
    }

    private static boolean isAspectJAdvice(Advisor advisor) {
        PointcutAdvisor pointcutAdvisor;
        return advisor instanceof InstantiationModelAwarePointcutAdvisor || advisor.getAdvice() instanceof AbstractAspectJAdvice || advisor instanceof PointcutAdvisor && (pointcutAdvisor = (PointcutAdvisor)advisor).getPointcut() instanceof AspectJExpressionPointcut;
    }

    static boolean isVariableName(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int length = name.length();
        for (int i = 1; i < length; ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

