/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.aspectj;

import cn.taketoday.aop.AfterAdvice;
import cn.taketoday.aop.AfterReturningAdvice;
import cn.taketoday.aop.aspectj.AbstractAspectJAdvice;
import cn.taketoday.aop.aspectj.AspectInstanceFactory;
import cn.taketoday.aop.aspectj.AspectJExpressionPointcut;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.aopalliance.intercept.MethodInvocation;

public class AspectJAfterReturningAdvice
extends AbstractAspectJAdvice
implements AfterReturningAdvice,
AfterAdvice,
Serializable {
    public AspectJAfterReturningAdvice(Method aspectJBeforeAdviceMethod, AspectJExpressionPointcut pointcut, AspectInstanceFactory aif) {
        super(aspectJBeforeAdviceMethod, pointcut, aif);
    }

    @Override
    public boolean isBeforeAdvice() {
        return false;
    }

    @Override
    public boolean isAfterAdvice() {
        return true;
    }

    @Override
    public void setReturningName(String name) {
        this.setReturningNameNoCheck(name);
    }

    @Override
    public void afterReturning(Object returnValue, MethodInvocation invocation) throws Throwable {
        if (this.shouldInvokeOnReturnValueOf(invocation.getMethod(), returnValue)) {
            this.invokeAdviceMethod(this.getJoinPointMatch(), returnValue, null);
        }
    }

    private boolean shouldInvokeOnReturnValueOf(Method method, @Nullable Object returnValue) {
        Class<?> type = this.getDiscoveredReturningType();
        Type genericType = this.getDiscoveredReturningGenericType();
        return this.matchesReturnValue(type, method, returnValue) && (genericType == null || genericType == type || TypeUtils.isAssignable((Type)genericType, (Type)method.getGenericReturnType()));
    }

    private boolean matchesReturnValue(Class<?> type, Method method, @Nullable Object returnValue) {
        if (returnValue != null) {
            return ClassUtils.isAssignableValue(type, (Object)returnValue);
        }
        if (Object.class == type && Void.TYPE == method.getReturnType()) {
            return true;
        }
        return ClassUtils.isAssignable(type, method.getReturnType());
    }
}

