/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.InterceptorChainFactory;
import cn.taketoday.aop.IntroductionAdvisor;
import cn.taketoday.aop.IntroductionAwareMethodMatcher;
import cn.taketoday.aop.MethodMatcher;
import cn.taketoday.aop.PointcutAdvisor;
import cn.taketoday.aop.framework.Advised;
import cn.taketoday.aop.framework.adapter.AdvisorAdapterRegistry;
import cn.taketoday.aop.framework.adapter.DefaultAdvisorAdapterRegistry;
import cn.taketoday.aop.support.RuntimeMethodInterceptor;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;

public class DefaultInterceptorChainFactory
implements InterceptorChainFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final DefaultInterceptorChainFactory INSTANCE = new DefaultInterceptorChainFactory();
    private AdvisorAdapterRegistry registry = DefaultAdvisorAdapterRegistry.getInstance();

    @Override
    public MethodInterceptor[] getInterceptors(Advised config, Method method, @Nullable Class<?> targetClass) {
        Advisor[] advisors = config.getAdvisors();
        ArrayList<MethodInterceptor> interceptorList = new ArrayList<MethodInterceptor>(advisors.length);
        Class<?> actualClass = targetClass != null ? targetClass : method.getDeclaringClass();
        Boolean hasIntroductions = null;
        for (Advisor advisor : advisors) {
            List<MethodInterceptor> interceptors;
            if (advisor instanceof PointcutAdvisor) {
                boolean match;
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                if (!config.isPreFiltered() && !pointcutAdvisor.getPointcut().getClassFilter().matches(actualClass)) continue;
                MethodMatcher matcher = pointcutAdvisor.getPointcut().getMethodMatcher();
                if (matcher instanceof IntroductionAwareMethodMatcher) {
                    if (hasIntroductions == null) {
                        hasIntroductions = DefaultInterceptorChainFactory.hasMatchingIntroductions(advisors, actualClass);
                    }
                    match = ((IntroductionAwareMethodMatcher)matcher).matches(method, actualClass, hasIntroductions);
                } else {
                    match = matcher.matches(method, actualClass);
                }
                if (!match) continue;
                List<MethodInterceptor> interceptors2 = this.registry.getInterceptors(advisor);
                if (matcher.isRuntime()) {
                    for (MethodInterceptor interceptor : interceptors2) {
                        interceptorList.add(new RuntimeMethodInterceptor(interceptor, matcher));
                    }
                    continue;
                }
                CollectionUtils.addAll(interceptorList, interceptors2);
                continue;
            }
            if (advisor instanceof IntroductionAdvisor) {
                IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
                if (!config.isPreFiltered() && !ia.getClassFilter().matches(actualClass)) continue;
                interceptors = this.registry.getInterceptors(advisor);
                interceptorList.addAll(interceptors);
                continue;
            }
            interceptors = this.registry.getInterceptors(advisor);
            interceptorList.addAll(interceptors);
        }
        if (interceptorList.isEmpty()) {
            return EMPTY_INTERCEPTOR;
        }
        return interceptorList.toArray(EMPTY_INTERCEPTOR);
    }

    private static boolean hasMatchingIntroductions(Advisor[] advisors, Class<?> actualClass) {
        for (Advisor advisor : advisors) {
            IntroductionAdvisor ia;
            if (!(advisor instanceof IntroductionAdvisor) || !(ia = (IntroductionAdvisor)advisor).getClassFilter().matches(actualClass)) continue;
            return true;
        }
        return false;
    }

    public void setRegistry(AdvisorAdapterRegistry registry) {
        Assert.notNull((Object)registry, (String)"AdvisorAdapterRegistry is required");
        this.registry = registry;
    }

    public AdvisorAdapterRegistry getRegistry() {
        return this.registry;
    }
}

