/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop;

import cn.taketoday.aop.TrueClassFilter;
import cn.taketoday.lang.Assert;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

@FunctionalInterface
public interface ClassFilter {
    public static final ClassFilter TRUE = TrueClassFilter.INSTANCE;

    public boolean matches(Class<?> var1);

    public static ClassFilter union(ClassFilter cf1, ClassFilter cf2) {
        Assert.notNull((Object)cf1, (String)"First ClassFilter must not be null");
        Assert.notNull((Object)cf2, (String)"Second ClassFilter must not be null");
        return new UnionClassFilter(new ClassFilter[]{cf1, cf2});
    }

    public static ClassFilter union(ClassFilter[] classFilters) {
        Assert.notEmpty((Object[])classFilters, (String)"ClassFilter array must not be empty");
        return new UnionClassFilter(classFilters);
    }

    public static ClassFilter intersection(ClassFilter cf1, ClassFilter cf2) {
        Assert.notNull((Object)cf1, (String)"First ClassFilter must not be null");
        Assert.notNull((Object)cf2, (String)"Second ClassFilter must not be null");
        return new IntersectionClassFilter(new ClassFilter[]{cf1, cf2});
    }

    public static ClassFilter intersection(ClassFilter[] classFilters) {
        Assert.notEmpty((Object[])classFilters, (String)"ClassFilter array must not be empty");
        return new IntersectionClassFilter(classFilters);
    }

    public static ClassFilter negate(ClassFilter classFilter) {
        Assert.notNull((Object)classFilter, (String)"ClassFilter must not be null");
        return new NegateClassFilter(classFilter);
    }

    public static class UnionClassFilter
    implements ClassFilter,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ClassFilter[] filters;

        private UnionClassFilter(ClassFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean matches(Class<?> clazz) {
            for (ClassFilter filter : this.filters) {
                if (!filter.matches(clazz)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof UnionClassFilter && Arrays.equals(this.filters, ((UnionClassFilter)other).filters);
        }

        public int hashCode() {
            return Arrays.hashCode(this.filters);
        }

        public String toString() {
            return this.getClass().getName() + ": " + Arrays.toString(this.filters);
        }
    }

    public static class IntersectionClassFilter
    implements ClassFilter,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ClassFilter[] filters;

        private IntersectionClassFilter(ClassFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean matches(Class<?> clazz) {
            for (ClassFilter filter : this.filters) {
                if (filter.matches(clazz)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof IntersectionClassFilter && Arrays.equals(this.filters, ((IntersectionClassFilter)other).filters);
        }

        public int hashCode() {
            return Arrays.hashCode(this.filters);
        }

        public String toString() {
            return this.getClass().getName() + ": " + Arrays.toString(this.filters);
        }
    }

    public static class NegateClassFilter
    implements ClassFilter,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ClassFilter original;

        private NegateClassFilter(ClassFilter original) {
            this.original = original;
        }

        @Override
        public boolean matches(Class<?> clazz) {
            return !this.original.matches(clazz);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof NegateClassFilter)) return false;
            NegateClassFilter that = (NegateClassFilter)other;
            if (!this.original.equals(that.original)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.original);
        }

        public String toString() {
            return "Negate " + this.original;
        }
    }
}

