/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;

public class TargetSource {
    private Object target;
    private Class<?> targetClass;
    private Class<?>[] interfaces;
    private Map<Method, List<MethodInterceptor>> aspectMappings;

    public TargetSource(Object target, Class<?> targetClass) {
        this.target = target;
        this.targetClass = targetClass;
        this.interfaces = targetClass.getInterfaces();
    }

    public String toString() {
        return "{\"targetClass\":\"" + this.targetClass + "\",\"interfaces\":\"" + Arrays.toString(this.interfaces) + "\",\"target\":\"" + this.target + "\"}";
    }

    public Object getTarget() {
        return this.target;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    public Map<Method, List<MethodInterceptor>> getAspectMappings() {
        return this.aspectMappings;
    }

    public TargetSource setTarget(Object target) {
        this.target = target;
        return this;
    }

    public TargetSource setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
        return this;
    }

    public TargetSource setInterfaces(Class<?>[] interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    public TargetSource setAspectMappings(Map<Method, List<MethodInterceptor>> aspectMappings) {
        this.aspectMappings = aspectMappings;
        return this;
    }
}

