/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.ProxyCreator;
import cn.taketoday.aop.ProxyFactory;
import cn.taketoday.aop.advice.AbstractAdvice;
import cn.taketoday.aop.advice.AspectsRegistry;
import cn.taketoday.aop.annotation.Advice;
import cn.taketoday.aop.annotation.AdviceImpl;
import cn.taketoday.aop.annotation.Aspect;
import cn.taketoday.aop.proxy.CglibProxyCreator;
import cn.taketoday.aop.proxy.TargetSource;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyFactory
implements ProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultProxyFactory.class);
    private final BeanFactory beanFactory;
    private final TargetSource targetSource;
    private final Map<Method, List<MethodInterceptor>> aspectMappings = new HashMap<Method, List<MethodInterceptor>>(16, 1.0f);

    public DefaultProxyFactory() {
        this(null, null);
    }

    public DefaultProxyFactory(TargetSource targetSource, BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.targetSource = targetSource;
    }

    @Override
    public Object getProxy() {
        List<Object> aspects = AspectsRegistry.getInstance().getAspects();
        try {
            boolean weaved = false;
            for (Object aspect : aspects) {
                Collection advices;
                Class<?> aspectClass = aspect.getClass();
                Class<?> targetClass = this.targetSource.getTargetClass();
                if (aspect instanceof MethodInterceptor && DefaultProxyFactory.matchClass(targetClass, advices = ClassUtils.getAnnotation(aspectClass, Advice.class, AdviceImpl.class))) {
                    weaved = this.matchMethod(aspect, null, targetClass, advices);
                }
                for (Method aspectMethod : aspectClass.getDeclaredMethods()) {
                    Collection advices2 = ClassUtils.getAnnotation((AnnotatedElement)aspectMethod, Advice.class, AdviceImpl.class);
                    if (advices2.isEmpty() || !DefaultProxyFactory.matchClass(targetClass, advices2)) continue;
                    if (weaved) {
                        this.matchMethod(aspect, aspectMethod, targetClass, advices2);
                        continue;
                    }
                    weaved = this.matchMethod(aspect, aspectMethod, targetClass, advices2);
                }
            }
            if (weaved) {
                return this.createAopProxy().createProxy();
            }
            return this.targetSource.getTarget();
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable((Throwable)ex);
            throw new ConfigurationException("An Exception Occured When Creating A Target Proxy Instance With Msg: [{}]", new Object[]{ex.getMessage(), ex});
        }
    }

    private boolean matchMethod(Object aspect, Method aspectMethod, Class<?> targetClass, Collection<Advice> advices) throws Throwable {
        boolean weaved = false;
        Method[] targetDeclaredMethods = targetClass.getDeclaredMethods();
        for (Advice advice : advices) {
            Class<? extends MethodInterceptor> interceptor = advice.interceptor();
            MethodInterceptor methodInterceptor = null;
            if (aspectMethod == null) {
                if (!(aspect instanceof MethodInterceptor)) {
                    throw new ConfigurationException("[{}] must be implement: [{}]", new Object[]{aspect.getClass().getName(), MethodInterceptor.class.getName()});
                }
                methodInterceptor = (MethodInterceptor)aspect;
            } else {
                methodInterceptor = DefaultProxyFactory.getInterceptor(aspect, aspectMethod, interceptor, this.beanFactory);
            }
            log.debug("Found Interceptor: [{}]", (Object)methodInterceptor);
            boolean isAllMethodsWeaved = false;
            for (Class<? extends Annotation> annotation : advice.value()) {
                if (targetClass.isAnnotationPresent(annotation)) {
                    weaved = true;
                    isAllMethodsWeaved = true;
                    log.debug("Class: [{}] Present An Annotation Named: [{}] All Method Will Be Weaving: [{}]", new Object[]{targetClass.getName(), annotation, advice});
                    for (Method targetMethod : targetDeclaredMethods) {
                        DefaultProxyFactory.weaving(methodInterceptor, targetMethod, this.aspectMappings);
                    }
                    continue;
                }
                log.debug("Class: [{}] Not Present An Annotation Named: [{}]", (Object)targetClass.getName(), annotation);
                for (Method targetMethod : targetDeclaredMethods) {
                    if (!targetMethod.isAnnotationPresent(annotation)) continue;
                    weaved = true;
                    DefaultProxyFactory.weaving(methodInterceptor, targetMethod, this.aspectMappings);
                }
            }
            if (isAllMethodsWeaved) continue;
            if (weaved) {
                this.regexMatchMethod(targetDeclaredMethods, advice, methodInterceptor);
                continue;
            }
            weaved = this.regexMatchMethod(targetDeclaredMethods, advice, methodInterceptor);
        }
        return weaved;
    }

    private boolean regexMatchMethod(Method[] targetDeclaredMethods, Advice advice, MethodInterceptor methodInterceptor) {
        String[] methodsStr = advice.method();
        boolean weaved = false;
        for (String methodStr : methodsStr) {
            String[] methodRegexs = methodStr.split("[;|,]");
            if (methodRegexs == null || methodRegexs.length == 0) {
                methodRegexs = new String[]{methodStr};
            }
            for (String methodRegex : methodRegexs) {
                for (Method targetMethod : targetDeclaredMethods) {
                    if (this.aspectMappings.containsKey(targetMethod) || !Pattern.matches(methodRegex, targetMethod.getName())) continue;
                    weaved = true;
                    DefaultProxyFactory.weaving(methodInterceptor, targetMethod, this.aspectMappings);
                }
            }
        }
        return weaved;
    }

    static boolean matchClass(Class<?> targetClass, Collection<Advice> advices) {
        for (Advice advice : advices) {
            for (Class<?> target : advice.target()) {
                if (target != targetClass) continue;
                return true;
            }
            Method[] targetDeclaredMethods = targetClass.getDeclaredMethods();
            for (Class<? extends Annotation> annotation : advice.value()) {
                if (targetClass.isAnnotationPresent(annotation)) {
                    return true;
                }
                for (Method targetMethod : targetDeclaredMethods) {
                    if (!targetMethod.isAnnotationPresent(annotation)) continue;
                    return true;
                }
            }
            String targetClassName = targetClass.getName();
            for (String regex : advice.pointcut()) {
                if (StringUtils.isEmpty((String)regex) || !Pattern.matches(regex, targetClassName)) continue;
                return true;
            }
        }
        return false;
    }

    static MethodInterceptor getInterceptor(Object aspect, Method aspectMethod, Class<? extends MethodInterceptor> interceptor, BeanFactory beanFactory) throws Throwable {
        MethodInterceptor bean;
        if (interceptor == AbstractAdvice.class || !MethodInterceptor.class.isAssignableFrom(interceptor)) {
            throw new ConfigurationException("You must be implement: [{}] or [{}]", new Object[]{AbstractAdvice.class.getName(), MethodInterceptor.class.getName()});
        }
        if (AbstractAdvice.class.isAssignableFrom(interceptor)) {
            return interceptor.getConstructor(Method.class, Object.class).newInstance(aspectMethod, aspect);
        }
        if (interceptor.isAnnotationPresent(Aspect.class) && (bean = (MethodInterceptor)beanFactory.getBean(interceptor)) != null) {
            return bean;
        }
        return interceptor.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    static void weaving(MethodInterceptor advice, Method targetMethod, Map<Method, List<MethodInterceptor>> aspectMappings) {
        List<MethodInterceptor> aspectMapping = aspectMappings.get(targetMethod);
        if (aspectMapping == null) {
            aspectMapping = new ArrayList<MethodInterceptor>();
            aspectMappings.put(targetMethod, aspectMapping);
        }
        aspectMapping.add(advice);
    }

    protected ProxyCreator createAopProxy() {
        this.targetSource.setAspectMappings(this.aspectMappings);
        return new CglibProxyCreator(this.targetSource);
    }
}

