/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.ProxyCreator;
import cn.taketoday.aop.cglib.proxy.Enhancer;
import cn.taketoday.aop.intercept.CglibMethodInterceptor;
import cn.taketoday.aop.proxy.TargetSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CglibProxyCreator
implements ProxyCreator {
    private static final Logger log = LoggerFactory.getLogger(CglibProxyCreator.class);
    private TargetSource targetSource;

    public CglibProxyCreator(TargetSource targetSource) {
        this.targetSource = targetSource;
    }

    @Override
    public Object createProxy() {
        log.debug("Creating Cglib Proxy, target source is: [{}]", (Object)this.targetSource);
        Class<?> targetClass = this.targetSource.getTargetClass();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(targetClass);
        enhancer.setInterfaces(this.targetSource.getInterfaces());
        enhancer.setInterceptDuringConstruction(false);
        enhancer.setCallback(new CglibMethodInterceptor(this.targetSource));
        return enhancer.create();
    }
}

