/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.listener;

import cn.taketoday.aop.advice.AspectsRegistry;
import cn.taketoday.aop.annotation.Aspect;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.ContextListener;
import cn.taketoday.context.annotation.Order;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.event.ContextPreRefreshEvent;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.listener.ApplicationListener;
import cn.taketoday.context.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ContextListener
@Order(value=-1073741823)
public class AspectsCreator
implements ApplicationListener<ContextPreRefreshEvent> {
    public void onApplicationEvent(ContextPreRefreshEvent event) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        log.debug("Loading Aspect Objects");
        AspectsRegistry aspectsRegistry = AspectsRegistry.getInstance();
        ApplicationContext applicationContext = event.getApplicationContext();
        try {
            for (BeanDefinition beanDefinition : applicationContext.getBeanDefinitionsMap().values()) {
                Class beanClass = beanDefinition.getBeanClass();
                if (!beanClass.isAnnotationPresent(Aspect.class)) continue;
                String aspectName = beanDefinition.getName();
                log.debug("Found Aspect: [{}]", (Object)aspectName);
                Object aspectInstance = applicationContext.getSingleton(aspectName);
                if (aspectInstance == null) {
                    aspectInstance = ClassUtils.newInstance((BeanDefinition)beanDefinition, (BeanFactory)applicationContext);
                    applicationContext.registerSingleton(aspectName, aspectInstance);
                }
                aspectsRegistry.addAspect(aspectInstance);
            }
            aspectsRegistry.sortAspects();
        }
        catch (Throwable e) {
            throw new ConfigurationException(e);
        }
    }
}

