/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.intercept;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DefaultMethodInvocation
implements MethodInvocation {
    private final Object target;
    private final Method method;
    private final Object[] args;
    private final MethodInterceptor[] advices;
    private int currentAdviceIndex = 0;
    private final int adviceLength;

    public DefaultMethodInvocation(Object target, Method method, Object[] arguments, MethodInterceptor[] advices) {
        this.target = target;
        this.method = method;
        this.advices = advices;
        this.args = arguments;
        this.adviceLength = advices.length;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getArguments() {
        return this.args;
    }

    @Override
    public Object proceed() throws Throwable {
        if (this.currentAdviceIndex == this.adviceLength) {
            return this.method.invoke(this.target, this.args);
        }
        return this.advices[this.currentAdviceIndex++].invoke(this);
    }

    @Override
    public Object getThis() {
        return this.target;
    }

    @Override
    public AccessibleObject getStaticPart() {
        return this.method;
    }

    public String toString() {
        return "{\n\t\"target\":\"" + this.target + "\",\n\t\"method\":\"" + this.method + "\",\n\t\"arguments\":\"" + Arrays.toString(this.args) + "\",\n\t\"advices\":\"" + Arrays.toString(this.advices) + "\",\n\t\"currentAdviceIndex\":\"" + this.currentAdviceIndex + "\"\n}";
    }
}

