/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.intercept;

import cn.taketoday.aop.cglib.proxy.MethodProxy;
import cn.taketoday.aop.intercept.DefaultMethodInvocation;
import cn.taketoday.aop.proxy.TargetSource;
import cn.taketoday.context.utils.OrderUtils;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;

public class CglibMethodInterceptor
implements cn.taketoday.aop.cglib.proxy.MethodInterceptor {
    private final Object target;
    private final Map<Method, MethodInterceptor[]> aspectMappings;

    public CglibMethodInterceptor(TargetSource targetSource) {
        this.target = targetSource.getTarget();
        Map<Method, List<MethodInterceptor>> aspectMappings_ = targetSource.getAspectMappings();
        this.aspectMappings = new HashMap<Method, MethodInterceptor[]>(aspectMappings_.size(), 1.0f);
        for (Map.Entry<Method, List<MethodInterceptor>> advices : aspectMappings_.entrySet()) {
            advices.getValue().sort(Comparator.comparingInt(OrderUtils::getOrder).reversed());
            this.aspectMappings.put(advices.getKey(), advices.getValue().toArray(new MethodInterceptor[0]));
        }
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        MethodInterceptor[] advices = this.aspectMappings.get(method);
        if (advices == null) {
            return proxy.invoke(this.target, args);
        }
        return new DefaultMethodInvocation(this.target, method, args, advices).proceed();
    }
}

