/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.cglib.proxy;

import cn.taketoday.aop.cglib.core.CodeGenerationException;
import cn.taketoday.aop.cglib.proxy.Callback;
import cn.taketoday.aop.cglib.proxy.CallbackFilter;
import cn.taketoday.aop.cglib.proxy.Enhancer;
import cn.taketoday.aop.cglib.proxy.InvocationHandler;
import cn.taketoday.aop.cglib.proxy.NoOp;
import java.io.Serializable;
import java.lang.reflect.Method;

public class Proxy
implements Serializable {
    protected InvocationHandler h;
    private static final CallbackFilter BAD_OBJECT_METHOD_FILTER = new CallbackFilter(){

        @Override
        public int accept(Method method) {
            String name;
            if (!(method.getDeclaringClass() != Object.class || (name = method.getName()).equals("hashCode") || name.equals("equals") || name.equals("toString"))) {
                return 1;
            }
            return 0;
        }
    };

    protected Proxy(InvocationHandler h) {
        Enhancer.registerCallbacks(this.getClass(), new Callback[]{h, null});
        this.h = h;
    }

    public static InvocationHandler getInvocationHandler(Object proxy) {
        if (!(proxy instanceof ProxyImpl)) {
            throw new IllegalArgumentException("Object is not a proxy");
        }
        return ((Proxy)proxy).h;
    }

    public static Class getProxyClass(ClassLoader loader, Class[] interfaces) {
        Enhancer e = new Enhancer();
        e.setSuperclass(ProxyImpl.class);
        e.setInterfaces(interfaces);
        e.setCallbackTypes(new Class[]{InvocationHandler.class, NoOp.class});
        e.setCallbackFilter(BAD_OBJECT_METHOD_FILTER);
        e.setUseFactory(false);
        return e.createClass();
    }

    public static boolean isProxyClass(Class cl) {
        return cl.getSuperclass().equals(ProxyImpl.class);
    }

    public static Object newProxyInstance(ClassLoader loader, Class[] interfaces, InvocationHandler h) {
        try {
            Class clazz = Proxy.getProxyClass(loader, interfaces);
            return clazz.getConstructor(InvocationHandler.class).newInstance(h);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private static class ProxyImpl
    extends Proxy {
        protected ProxyImpl(InvocationHandler h) {
            super(h);
        }
    }
}

