/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.cglib.proxy;

import cn.taketoday.aop.cglib.core.ClassEmitter;
import cn.taketoday.aop.cglib.core.CodeEmitter;
import cn.taketoday.aop.cglib.core.MethodInfo;
import cn.taketoday.aop.cglib.core.Signature;
import cn.taketoday.aop.cglib.core.TypeUtils;
import cn.taketoday.aop.cglib.proxy.CallbackGenerator;
import cn.taketoday.context.asm.Type;
import java.util.List;

class FixedValueGenerator
implements CallbackGenerator {
    public static final FixedValueGenerator INSTANCE = new FixedValueGenerator();
    private static final Type FIXED_VALUE = TypeUtils.parseType("cn.taketoday.aop.cglib.proxy.FixedValue");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");

    FixedValueGenerator() {
    }

    @Override
    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods) {
        for (MethodInfo method : methods) {
            CodeEmitter e = context.beginMethod(ce, method);
            context.emitCallback(e, context.getIndex(method));
            e.invoke_interface(FIXED_VALUE, LOAD_OBJECT);
            e.unbox_or_zero(e.getReturnType());
            e.return_value();
            e.end_method();
        }
    }

    @Override
    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List methods) {
    }
}

