/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.cglib.proxy;

import cn.taketoday.aop.cglib.core.ReflectUtils;
import cn.taketoday.aop.cglib.proxy.Callback;
import cn.taketoday.aop.cglib.proxy.CallbackFilter;
import cn.taketoday.aop.cglib.proxy.Enhancer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CallbackHelper
implements CallbackFilter {
    private List<Object> callbacks = new ArrayList<Object>();
    private Map<Method, Integer> methodMap = new HashMap<Method, Integer>();

    public CallbackHelper(Class<?> superclass, Class<?>[] interfaces) {
        ArrayList methods = new ArrayList();
        Enhancer.getMethods(superclass, interfaces, methods);
        HashMap<Object, Integer> indexes = new HashMap<Object, Integer>();
        int size = methods.size();
        for (int i = 0; i < size; ++i) {
            Method method = (Method)methods.get(i);
            Object callback = this.getCallback(method);
            if (callback == null) {
                throw new IllegalStateException("getCallback cannot return null");
            }
            boolean isCallback = callback instanceof Callback;
            if (!isCallback && !(callback instanceof Class)) {
                throw new IllegalStateException("getCallback must return a Callback or a Class");
            }
            if (i > 0 && this.callbacks.get(i - 1) instanceof Callback ^ isCallback) {
                throw new IllegalStateException("getCallback must return a Callback or a Class consistently for every Method");
            }
            Integer index = (Integer)indexes.get(callback);
            if (index == null) {
                index = new Integer(this.callbacks.size());
                indexes.put(callback, index);
            }
            this.methodMap.put(method, index);
            this.callbacks.add(callback);
        }
    }

    protected abstract Object getCallback(Method var1);

    public Callback[] getCallbacks() {
        if (this.callbacks.size() == 0) {
            return new Callback[0];
        }
        if (this.callbacks.get(0) instanceof Callback) {
            return this.callbacks.toArray(new Callback[this.callbacks.size()]);
        }
        throw new IllegalStateException("getCallback returned classes, not callbacks; call getCallbackTypes instead");
    }

    public Class<?>[] getCallbackTypes() {
        if (this.callbacks.size() == 0) {
            return new Class[0];
        }
        if (this.callbacks.get(0) instanceof Callback) {
            return ReflectUtils.getClasses(this.getCallbacks());
        }
        return this.callbacks.toArray(new Class[this.callbacks.size()]);
    }

    @Override
    public int accept(Method method) {
        return this.methodMap.get(method);
    }

    public int hashCode() {
        return this.methodMap.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof CallbackHelper)) {
            return false;
        }
        return this.methodMap.equals(((CallbackHelper)o).methodMap);
    }
}

