/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.advice;

import cn.taketoday.aop.annotation.Annotated;
import cn.taketoday.aop.annotation.Argument;
import cn.taketoday.aop.annotation.Arguments;
import cn.taketoday.aop.annotation.JoinPoint;
import cn.taketoday.aop.annotation.Returning;
import cn.taketoday.aop.annotation.Throwing;
import cn.taketoday.context.utils.ExceptionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Joinpoint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class AbstractAdvice
implements Advice,
MethodInterceptor {
    private final Object aspect;
    private final Method adviceMethod;
    private final byte[] adviceParameters;
    private final int adviceParameterLength;
    private final Class<?>[] adviceParameterTypes;

    public AbstractAdvice(Method adviceMethod, Object aspect) {
        this.aspect = aspect;
        this.adviceMethod = adviceMethod;
        this.adviceParameterLength = adviceMethod.getParameterCount();
        this.adviceParameters = new byte[this.adviceParameterLength];
        this.adviceParameterTypes = adviceMethod.getParameterTypes();
        Parameter[] parameters = adviceMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            this.adviceParameters[i] = 0;
            if (parameter.isAnnotationPresent(JoinPoint.class)) {
                this.adviceParameters[i] = 6;
            }
            if (parameter.isAnnotationPresent(Argument.class)) {
                this.adviceParameters[i] = 2;
            }
            if (parameter.isAnnotationPresent(Arguments.class)) {
                this.adviceParameters[i] = 3;
            }
            if (parameter.isAnnotationPresent(Returning.class)) {
                this.adviceParameters[i] = 4;
            }
            if (parameter.isAnnotationPresent(Throwing.class)) {
                this.adviceParameters[i] = 1;
            }
            if (!parameter.isAnnotationPresent(Annotated.class)) continue;
            this.adviceParameters[i] = 5;
        }
    }

    @Override
    public abstract Object invoke(MethodInvocation var1) throws Throwable;

    protected Object invokeAdviceMethod(MethodInvocation methodInvocation, Object returnValue, Throwable throwable) throws Throwable {
        if (this.adviceParameterLength == 0) {
            return this.adviceMethod.invoke(this.aspect, new Object[0]);
        }
        return this.adviceMethod.invoke(this.aspect, this.resolveParameter(methodInvocation, returnValue, throwable));
    }

    private final Object[] resolveParameter(MethodInvocation methodInvocation, Object returnValue, Throwable ex) {
        Object[] args = new Object[this.adviceParameterLength];
        block8: for (int i = 0; i < this.adviceParameterLength; ++i) {
            switch (this.adviceParameters[i]) {
                case 1: {
                    if (ex == null) continue block8;
                    Class<?> parameterType = this.adviceParameterTypes[i];
                    Object throwable = ExceptionUtils.unwrapThrowable((Throwable)ex);
                    if (parameterType != Throwable.class && !parameterType.isAssignableFrom(throwable.getClass())) continue block8;
                    args[i] = throwable;
                    continue block8;
                }
                case 2: {
                    Object[] arguments = methodInvocation.getArguments();
                    if (arguments.length == 1) {
                        args[i] = arguments[0];
                        continue block8;
                    }
                    for (Object argument : arguments) {
                        if (argument == null || argument.getClass() != this.adviceParameterTypes[i]) continue;
                        args[i] = argument;
                        continue block8;
                    }
                    continue block8;
                }
                case 3: {
                    args[i] = methodInvocation.getArguments();
                    continue block8;
                }
                case 4: {
                    args[i] = returnValue;
                    continue block8;
                }
                case 5: {
                    args[i] = this.resolveAnnotation(methodInvocation, this.adviceParameterTypes[i]);
                    continue block8;
                }
                case 6: {
                    args[i] = methodInvocation;
                    continue block8;
                }
                default: {
                    Object throwable;
                    Class<?> parameterType = this.adviceParameterTypes[i];
                    if (Joinpoint.class.isAssignableFrom(parameterType)) {
                        args[i] = methodInvocation;
                    }
                    if (Annotation.class.isAssignableFrom(parameterType)) {
                        args[i] = this.resolveAnnotation(methodInvocation, parameterType);
                    }
                    if (ex != null) {
                        throwable = ExceptionUtils.unwrapThrowable((Throwable)ex);
                        if (parameterType == Throwable.class || parameterType.isAssignableFrom(throwable.getClass())) {
                            args[i] = throwable;
                        }
                    }
                    if (returnValue == null || !parameterType.isAssignableFrom(returnValue.getClass())) continue block8;
                    args[i] = returnValue;
                    continue block8;
                }
            }
        }
        return args;
    }

    private final Object resolveAnnotation(MethodInvocation methodInvocation, Class<? extends Annotation> annotationClass) {
        Method method = methodInvocation.getMethod();
        Annotation annotation = method.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(annotationClass);
        }
        return annotation;
    }
}

