/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.processor.metadata;

import cn.taketoday.context.properties.json.JSONArray;
import cn.taketoday.context.properties.json.JSONObject;
import cn.taketoday.context.properties.processor.metadata.ConfigurationMetadata;
import cn.taketoday.context.properties.processor.metadata.ItemDeprecation;
import cn.taketoday.context.properties.processor.metadata.ItemHint;
import cn.taketoday.context.properties.processor.metadata.ItemMetadata;
import cn.taketoday.context.properties.processor.metadata.JsonConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class JsonMarshaller {
    public void write(ConfigurationMetadata metadata, OutputStream outputStream) throws IOException {
        try {
            JSONObject object = new JSONObject();
            JsonConverter converter = new JsonConverter();
            object.put("groups", converter.toJsonArray(metadata, ItemMetadata.ItemType.GROUP));
            object.put("properties", converter.toJsonArray(metadata, ItemMetadata.ItemType.PROPERTY));
            object.put("hints", converter.toJsonArray(metadata.getHints()));
            outputStream.write(object.toString(2).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                IOException ioException = (IOException)ex;
                throw ioException;
            }
            if (ex instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)ex;
                throw runtimeException;
            }
            throw new IllegalStateException(ex);
        }
    }

    public ConfigurationMetadata read(InputStream inputStream) throws Exception {
        JSONArray hints;
        JSONArray properties;
        ConfigurationMetadata metadata = new ConfigurationMetadata();
        JSONObject object = new JSONObject(this.toString(inputStream));
        JsonPath path = JsonPath.root();
        this.checkAllowedKeys(object, path, "groups", "properties", "hints");
        JSONArray groups = object.optJSONArray("groups");
        if (groups != null) {
            for (int i = 0; i < groups.length(); ++i) {
                metadata.add(this.toItemMetadata((JSONObject)groups.get(i), path.resolve("groups").index(i), ItemMetadata.ItemType.GROUP));
            }
        }
        if ((properties = object.optJSONArray("properties")) != null) {
            for (int i = 0; i < properties.length(); ++i) {
                metadata.add(this.toItemMetadata((JSONObject)properties.get(i), path.resolve("properties").index(i), ItemMetadata.ItemType.PROPERTY));
            }
        }
        if ((hints = object.optJSONArray("hints")) != null) {
            for (int i = 0; i < hints.length(); ++i) {
                metadata.add(this.toItemHint((JSONObject)hints.get(i), path.resolve("hints").index(i)));
            }
        }
        return metadata;
    }

    private ItemMetadata toItemMetadata(JSONObject object, JsonPath path, ItemMetadata.ItemType itemType) throws Exception {
        switch (itemType) {
            case GROUP: {
                this.checkAllowedKeys(object, path, "name", "type", "description", "sourceType", "sourceMethod");
                break;
            }
            case PROPERTY: {
                this.checkAllowedKeys(object, path, "name", "type", "description", "sourceType", "defaultValue", "deprecation", "deprecated");
            }
        }
        String name = object.getString("name");
        String type = object.optString("type", null);
        String description = object.optString("description", null);
        String sourceType = object.optString("sourceType", null);
        String sourceMethod = object.optString("sourceMethod", null);
        Object defaultValue = this.readItemValue(object.opt("defaultValue"));
        ItemDeprecation deprecation = this.toItemDeprecation(object, path);
        return new ItemMetadata(itemType, name, null, type, sourceType, sourceMethod, description, defaultValue, deprecation);
    }

    private ItemDeprecation toItemDeprecation(JSONObject object, JsonPath path) throws Exception {
        if (object.has("deprecation")) {
            JSONObject deprecationJsonObject = object.getJSONObject("deprecation");
            this.checkAllowedKeys(deprecationJsonObject, path.resolve("deprecation"), "level", "reason", "replacement", "since");
            ItemDeprecation deprecation = new ItemDeprecation();
            deprecation.setLevel(deprecationJsonObject.optString("level", null));
            deprecation.setReason(deprecationJsonObject.optString("reason", null));
            deprecation.setReplacement(deprecationJsonObject.optString("replacement", null));
            deprecation.setSince(deprecationJsonObject.optString("since", null));
            return deprecation;
        }
        return object.optBoolean("deprecated") ? new ItemDeprecation() : null;
    }

    private ItemHint toItemHint(JSONObject object, JsonPath path) throws Exception {
        this.checkAllowedKeys(object, path, "name", "values", "providers");
        String name = object.getString("name");
        ArrayList<ItemHint.ValueHint> values = new ArrayList<ItemHint.ValueHint>();
        if (object.has("values")) {
            JSONArray valuesArray = object.getJSONArray("values");
            for (int i = 0; i < valuesArray.length(); ++i) {
                values.add(this.toValueHint((JSONObject)valuesArray.get(i), path.resolve("values").index(i)));
            }
        }
        ArrayList<ItemHint.ValueProvider> providers = new ArrayList<ItemHint.ValueProvider>();
        if (object.has("providers")) {
            JSONArray providersObject = object.getJSONArray("providers");
            for (int i = 0; i < providersObject.length(); ++i) {
                providers.add(this.toValueProvider((JSONObject)providersObject.get(i), path.resolve("providers").index(i)));
            }
        }
        return new ItemHint(name, values, providers);
    }

    private ItemHint.ValueHint toValueHint(JSONObject object, JsonPath path) throws Exception {
        this.checkAllowedKeys(object, path, "value", "description");
        Object value = this.readItemValue(object.get("value"));
        String description = object.optString("description", null);
        return new ItemHint.ValueHint(value, description);
    }

    private ItemHint.ValueProvider toValueProvider(JSONObject object, JsonPath path) throws Exception {
        this.checkAllowedKeys(object, path, "name", "parameters");
        String name = object.getString("name");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (object.has("parameters")) {
            JSONObject parametersObject = object.getJSONObject("parameters");
            Iterator iterator = parametersObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = this.readItemValue(parametersObject.get(key));
                parameters.put(key, value);
            }
        }
        return new ItemHint.ValueProvider(name, parameters);
    }

    private Object readItemValue(Object value) throws Exception {
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            Object[] content = new Object[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                content[i] = array.get(i);
            }
            return content;
        }
        return value;
    }

    private String toString(InputStream inputStream) throws IOException {
        return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
    }

    private void checkAllowedKeys(JSONObject object, JsonPath path, String ... allowedKeys) {
        TreeSet availableKeys = new TreeSet();
        object.keys().forEachRemaining(key -> availableKeys.add((String)key));
        Arrays.stream(allowedKeys).forEach(availableKeys::remove);
        if (!availableKeys.isEmpty()) {
            throw new IllegalStateException("Expected only keys %s, but found additional keys %s. Path: %s".formatted(new TreeSet<String>(Arrays.asList(allowedKeys)), availableKeys, path));
        }
    }

    private static final class JsonPath {
        private final String path;

        private JsonPath(String path) {
            this.path = path;
        }

        JsonPath resolve(String path) {
            if (this.path.endsWith(".")) {
                return new JsonPath(this.path + path);
            }
            return new JsonPath(this.path + "." + path);
        }

        JsonPath index(int index) {
            return this.resolve("[%d]".formatted(index));
        }

        public String toString() {
            return this.path;
        }

        static JsonPath root() {
            return new JsonPath(".");
        }
    }
}

