/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.processor;

import cn.taketoday.context.properties.processor.MetadataCollector;
import cn.taketoday.context.properties.processor.MetadataGenerationEnvironment;
import cn.taketoday.context.properties.processor.MetadataStore;
import cn.taketoday.context.properties.processor.PropertyDescriptorResolver;
import cn.taketoday.context.properties.processor.metadata.ConfigurationMetadata;
import cn.taketoday.context.properties.processor.metadata.InvalidConfigurationMetadataException;
import cn.taketoday.context.properties.processor.metadata.ItemMetadata;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"cn.taketoday.context.annotation.config.AutoConfiguration", "cn.taketoday.context.properties.ConfigurationProperties", "cn.taketoday.context.annotation.config.DisableDIAutoConfiguration", "cn.taketoday.context.annotation.Configuration"})
public class ConfigurationMetadataAnnotationProcessor
extends AbstractProcessor {
    static final String ADDITIONAL_METADATA_LOCATIONS_OPTION = "cn.taketoday.context.properties.additionalMetadataLocations";
    static final String CONFIGURATION_PROPERTIES_ANNOTATION = "cn.taketoday.context.properties.ConfigurationProperties";
    static final String NESTED_CONFIGURATION_PROPERTY_ANNOTATION = "cn.taketoday.context.properties.NestedConfigurationProperty";
    static final String DEPRECATED_CONFIGURATION_PROPERTY_ANNOTATION = "cn.taketoday.context.properties.DeprecatedConfigurationProperty";
    static final String CONSTRUCTOR_BINDING_ANNOTATION = "cn.taketoday.context.properties.bind.ConstructorBinding";
    static final String AUTOWIRED_ANNOTATION = "cn.taketoday.beans.factory.annotation.Autowired";
    static final String DEFAULT_VALUE_ANNOTATION = "cn.taketoday.context.properties.bind.DefaultValue";
    static final String NAME_ANNOTATION = "cn.taketoday.context.properties.bind.Name";
    static final String AUTO_CONFIGURATION_ANNOTATION = "cn.taketoday.context.annotation.config.AutoConfiguration";
    static final String DisableDIAUTO_CONFIGURATION_ANNOTATION = "cn.taketoday.context.annotation.config.DisableDIAutoConfiguration";
    private static final Set<String> SUPPORTED_OPTIONS = Collections.singleton("cn.taketoday.context.properties.additionalMetadataLocations");
    private MetadataStore metadataStore;
    private MetadataCollector metadataCollector;
    private MetadataGenerationEnvironment metadataEnv;

    protected String configurationPropertiesAnnotation() {
        return CONFIGURATION_PROPERTIES_ANNOTATION;
    }

    protected String nestedConfigurationPropertyAnnotation() {
        return NESTED_CONFIGURATION_PROPERTY_ANNOTATION;
    }

    protected String deprecatedConfigurationPropertyAnnotation() {
        return DEPRECATED_CONFIGURATION_PROPERTY_ANNOTATION;
    }

    protected String constructorBindingAnnotation() {
        return CONSTRUCTOR_BINDING_ANNOTATION;
    }

    protected String autowiredAnnotation() {
        return AUTOWIRED_ANNOTATION;
    }

    protected String defaultValueAnnotation() {
        return DEFAULT_VALUE_ANNOTATION;
    }

    protected Set<String> endpointAnnotations() {
        return new HashSet<String>();
    }

    protected String readOperationAnnotation() {
        return null;
    }

    protected String nameAnnotation() {
        return NAME_ANNOTATION;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.metadataStore = new MetadataStore(env);
        this.metadataCollector = new MetadataCollector(env, this.metadataStore.readMetadata());
        this.metadataEnv = new MetadataGenerationEnvironment(env, this.configurationPropertiesAnnotation(), this.nestedConfigurationPropertyAnnotation(), this.deprecatedConfigurationPropertyAnnotation(), this.constructorBindingAnnotation(), this.autowiredAnnotation(), this.defaultValueAnnotation(), this.endpointAnnotations(), this.readOperationAnnotation(), this.nameAnnotation());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<TypeElement> endpointTypes;
        this.metadataCollector.processing(roundEnv);
        TypeElement annotationType = this.metadataEnv.getConfigurationPropertiesAnnotationElement();
        if (annotationType != null) {
            for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
                this.processElement(element);
            }
        }
        if (!(endpointTypes = this.metadataEnv.getEndpointAnnotationElements()).isEmpty()) {
            for (TypeElement endpointType : endpointTypes) {
                this.getElementsAnnotatedOrMetaAnnotatedWith(roundEnv, endpointType).forEach(this::processEndpoint);
            }
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeMetadata();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to write metadata", exception);
            }
        }
        return false;
    }

    private Map<Element, List<Element>> getElementsAnnotatedOrMetaAnnotatedWith(RoundEnvironment roundEnv, TypeElement annotation) {
        LinkedHashMap<Element, List<Element>> result = new LinkedHashMap<Element, List<Element>>();
        for (Element element : roundEnv.getRootElements()) {
            List<Element> annotations = this.metadataEnv.getElementsAnnotatedOrMetaAnnotatedWith(element, annotation);
            if (annotations.isEmpty()) continue;
            result.put(element, annotations);
        }
        return result;
    }

    private void processElement(Element element) {
        try {
            AnnotationMirror annotation = this.metadataEnv.getConfigurationPropertiesAnnotation(element);
            if (annotation != null) {
                String prefix = this.getPrefix(annotation);
                if (element instanceof TypeElement) {
                    TypeElement typeElement = (TypeElement)element;
                    this.processAnnotatedTypeElement(prefix, typeElement, new ArrayDeque<TypeElement>());
                } else if (element instanceof ExecutableElement) {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    this.processExecutableElement(prefix, executableElement, new ArrayDeque<TypeElement>());
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + element, ex);
        }
    }

    private void processAnnotatedTypeElement(String prefix, TypeElement element, Deque<TypeElement> seen) {
        String type = this.metadataEnv.getTypeUtils().getQualifiedName(element);
        this.metadataCollector.add(ItemMetadata.newGroup(prefix, type, type, null));
        this.processTypeElement(prefix, element, null, seen);
    }

    private void processExecutableElement(String prefix, ExecutableElement element, Deque<TypeElement> seen) {
        Element returns;
        if (!element.getModifiers().contains((Object)Modifier.PRIVATE) && TypeKind.VOID != element.getReturnType().getKind() && (returns = this.processingEnv.getTypeUtils().asElement(element.getReturnType())) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)returns;
            ItemMetadata group = ItemMetadata.newGroup(prefix, this.metadataEnv.getTypeUtils().getQualifiedName(returns), this.metadataEnv.getTypeUtils().getQualifiedName(element.getEnclosingElement()), element.toString());
            if (this.metadataCollector.hasSimilarGroup(group)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate @ConfigurationProperties definition for prefix '" + prefix + "'", element);
            } else {
                this.metadataCollector.add(group);
                this.processTypeElement(prefix, typeElement, element, seen);
            }
        }
    }

    private void processTypeElement(String prefix, TypeElement element, ExecutableElement source, Deque<TypeElement> seen) {
        if (!seen.contains(element)) {
            seen.push(element);
            new PropertyDescriptorResolver(this.metadataEnv).resolve(element, source).forEach(descriptor -> {
                this.metadataCollector.add(descriptor.resolveItemMetadata(prefix, this.metadataEnv));
                if (descriptor.isNested(this.metadataEnv)) {
                    TypeElement nestedTypeElement = (TypeElement)this.metadataEnv.getTypeUtils().asElement(descriptor.getType());
                    String nestedPrefix = ConfigurationMetadata.nestedPrefix(prefix, descriptor.getName());
                    this.processTypeElement(nestedPrefix, nestedTypeElement, source, seen);
                }
            });
            seen.pop();
        }
    }

    private void processEndpoint(Element element, List<Element> annotations) {
        try {
            String annotationName = this.metadataEnv.getTypeUtils().getQualifiedName(annotations.get(0));
            AnnotationMirror annotation = this.metadataEnv.getAnnotation(element, annotationName);
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                this.processEndpoint(annotation, typeElement);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + element, ex);
        }
    }

    private void processEndpoint(AnnotationMirror annotation, TypeElement element) {
        Map<String, Object> elementValues = this.metadataEnv.getAnnotationElementValues(annotation);
        String endpointId = (String)elementValues.get("id");
        if (endpointId == null || endpointId.isEmpty()) {
            return;
        }
        String endpointKey = ItemMetadata.newItemMetadataPrefix("management.endpoint.", endpointId);
        Boolean enabledByDefault = (Boolean)elementValues.get("enableByDefault");
        String type = this.metadataEnv.getTypeUtils().getQualifiedName(element);
        this.metadataCollector.add(ItemMetadata.newGroup(endpointKey, type, type, null));
        this.metadataCollector.add(ItemMetadata.newProperty(endpointKey, "enabled", Boolean.class.getName(), type, null, String.format("Whether to enable the %s endpoint.", endpointId), enabledByDefault != null ? enabledByDefault : true, null));
        if (this.hasMainReadOperation(element)) {
            this.metadataCollector.add(ItemMetadata.newProperty(endpointKey, "cache.time-to-live", Duration.class.getName(), type, null, "Maximum time that a response can be cached.", "0ms", null));
        }
    }

    private boolean hasMainReadOperation(TypeElement element) {
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            if (this.metadataEnv.getReadOperationAnnotation(method) == null || TypeKind.VOID == method.getReturnType().getKind() || !this.hasNoOrOptionalParameters(method)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNoOrOptionalParameters(ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            if (this.metadataEnv.hasNullableAnnotation(variableElement)) continue;
            return false;
        }
        return true;
    }

    private String getPrefix(AnnotationMirror annotation) {
        String prefix = this.metadataEnv.getAnnotationElementStringValue(annotation, "prefix");
        if (prefix != null) {
            return prefix;
        }
        return this.metadataEnv.getAnnotationElementStringValue(annotation, "value");
    }

    protected ConfigurationMetadata writeMetadata() throws Exception {
        ConfigurationMetadata metadata = this.metadataCollector.getMetadata();
        if (!(metadata = this.mergeAdditionalMetadata(metadata)).getItems().isEmpty()) {
            this.metadataStore.writeMetadata(metadata);
            return metadata;
        }
        return null;
    }

    private ConfigurationMetadata mergeAdditionalMetadata(ConfigurationMetadata metadata) {
        try {
            ConfigurationMetadata merged = new ConfigurationMetadata(metadata);
            merged.merge(this.metadataStore.readAdditionalMetadata());
            return merged;
        }
        catch (FileNotFoundException merged) {
        }
        catch (InvalidConfigurationMetadataException ex) {
            this.log(ex.getKind(), ex.getMessage());
        }
        catch (Exception ex) {
            this.logWarning("Unable to merge additional metadata");
            this.logWarning(this.getStackTrace(ex));
        }
        return metadata;
    }

    private String getStackTrace(Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)writer, true));
        return writer.toString();
    }

    private void logWarning(String msg) {
        this.log(Diagnostic.Kind.WARNING, msg);
    }

    private void log(Diagnostic.Kind kind, String msg) {
        this.processingEnv.getMessager().printMessage(kind, msg);
    }
}

