/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.properties.metadata;

import cn.taketoday.context.properties.metadata.ConfigurationMetadataGroup;
import cn.taketoday.context.properties.metadata.ConfigurationMetadataProperty;
import cn.taketoday.context.properties.metadata.ConfigurationMetadataRepository;
import cn.taketoday.context.properties.metadata.ConfigurationMetadataSource;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleConfigurationMetadataRepository
implements ConfigurationMetadataRepository,
Serializable {
    private final Map<String, ConfigurationMetadataGroup> allGroups = new HashMap<String, ConfigurationMetadataGroup>();

    @Override
    public Map<String, ConfigurationMetadataGroup> getAllGroups() {
        return Collections.unmodifiableMap(this.allGroups);
    }

    @Override
    public Map<String, ConfigurationMetadataProperty> getAllProperties() {
        HashMap<String, ConfigurationMetadataProperty> properties = new HashMap<String, ConfigurationMetadataProperty>();
        for (ConfigurationMetadataGroup group : this.allGroups.values()) {
            properties.putAll(group.getProperties());
        }
        return properties;
    }

    public void add(Collection<ConfigurationMetadataSource> sources) {
        for (ConfigurationMetadataSource source : sources) {
            String groupId = source.getGroupId();
            ConfigurationMetadataGroup group = this.allGroups.computeIfAbsent(groupId, key -> new ConfigurationMetadataGroup(groupId));
            String sourceType = source.getType();
            if (sourceType == null) continue;
            this.addOrMergeSource(group.getSources(), sourceType, source);
        }
    }

    public void add(ConfigurationMetadataProperty property, ConfigurationMetadataSource source) {
        if (source != null) {
            source.getProperties().putIfAbsent(property.getId(), property);
        }
        this.getGroup(source).getProperties().putIfAbsent(property.getId(), property);
    }

    public void include(ConfigurationMetadataRepository repository) {
        for (ConfigurationMetadataGroup group : repository.getAllGroups().values()) {
            ConfigurationMetadataGroup existingGroup = this.allGroups.get(group.getId());
            if (existingGroup == null) {
                this.allGroups.put(group.getId(), group);
                continue;
            }
            group.getProperties().forEach((name, value) -> existingGroup.getProperties().putIfAbsent((String)name, (ConfigurationMetadataProperty)value));
            group.getSources().forEach((name, value) -> this.addOrMergeSource(existingGroup.getSources(), (String)name, (ConfigurationMetadataSource)value));
        }
    }

    private ConfigurationMetadataGroup getGroup(ConfigurationMetadataSource source) {
        if (source == null) {
            return this.allGroups.computeIfAbsent("_ROOT_GROUP_", key -> new ConfigurationMetadataGroup("_ROOT_GROUP_"));
        }
        return this.allGroups.get(source.getGroupId());
    }

    private void addOrMergeSource(Map<String, ConfigurationMetadataSource> sources, String name, ConfigurationMetadataSource source) {
        ConfigurationMetadataSource existingSource = sources.get(name);
        if (existingSource == null) {
            sources.put(name, source);
        } else {
            source.getProperties().forEach((k, v) -> existingSource.getProperties().putIfAbsent((String)k, (ConfigurationMetadataProperty)v));
        }
    }
}

