/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.io;

import cn.taketoday.buildpack.platform.io.Content;
import cn.taketoday.buildpack.platform.io.Layout;
import cn.taketoday.buildpack.platform.io.Owner;
import cn.taketoday.buildpack.platform.io.TarArchive;
import cn.taketoday.util.StreamUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

class TarLayoutWriter
implements Layout,
Closeable {
    static final long NORMALIZED_MOD_TIME = TarArchive.NORMALIZED_TIME.toEpochMilli();
    private final TarArchiveOutputStream outputStream;

    TarLayoutWriter(OutputStream outputStream) {
        this.outputStream = new TarArchiveOutputStream(outputStream);
        this.outputStream.setLongFileMode(3);
    }

    @Override
    public void directory(String name, Owner owner, int mode) throws IOException {
        this.outputStream.putArchiveEntry(this.createDirectoryEntry(name, owner, mode));
        this.outputStream.closeArchiveEntry();
    }

    @Override
    public void file(String name, Owner owner, int mode, Content content) throws IOException {
        this.outputStream.putArchiveEntry(this.createFileEntry(name, owner, mode, content.size()));
        content.writeTo(StreamUtils.nonClosing((OutputStream)this.outputStream));
        this.outputStream.closeArchiveEntry();
    }

    private TarArchiveEntry createDirectoryEntry(String name, Owner owner, int mode) {
        return this.createEntry(name, owner, (byte)53, mode, 0);
    }

    private TarArchiveEntry createFileEntry(String name, Owner owner, int mode, int size) {
        return this.createEntry(name, owner, (byte)48, mode, size);
    }

    private TarArchiveEntry createEntry(String name, Owner owner, byte linkFlag, int mode, int size) {
        TarArchiveEntry entry = new TarArchiveEntry(name, linkFlag, true);
        entry.setUserId(owner.getUid());
        entry.setGroupId(owner.getGid());
        entry.setMode(mode);
        entry.setModTime(NORMALIZED_MOD_TIME);
        entry.setSize((long)size);
        return entry;
    }

    void finish() throws IOException {
        this.outputStream.finish();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

