/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.io;

import cn.taketoday.buildpack.platform.io.IOConsumer;
import cn.taketoday.buildpack.platform.io.Layout;
import cn.taketoday.buildpack.platform.io.Owner;
import cn.taketoday.buildpack.platform.io.TarLayoutWriter;
import cn.taketoday.buildpack.platform.io.ZipFileTarArchive;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

@FunctionalInterface
public interface TarArchive {
    public static final Instant NORMALIZED_TIME = OffsetDateTime.of(1980, 1, 1, 0, 0, 1, 0, ZoneOffset.UTC).toInstant();

    public void writeTo(OutputStream var1) throws IOException;

    public static TarArchive of(IOConsumer<Layout> layout) {
        return outputStream -> {
            TarLayoutWriter writer = new TarLayoutWriter(outputStream);
            layout.accept(writer);
            writer.finish();
        };
    }

    public static TarArchive fromZip(File zip, Owner owner) {
        return new ZipFileTarArchive(zip, owner);
    }
}

