/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker.type;

import cn.taketoday.buildpack.platform.json.MappedObject;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImageArchiveManifest
extends MappedObject {
    private final List<ManifestEntry> entries = new ArrayList<ManifestEntry>();

    protected ImageArchiveManifest(JsonNode node) {
        super(node, MethodHandles.lookup());
        this.getNode().elements().forEachRemaining(element -> this.entries.add(ManifestEntry.of(element)));
    }

    public List<ManifestEntry> getEntries() {
        return this.entries;
    }

    public static ImageArchiveManifest of(InputStream content) throws IOException {
        return ImageArchiveManifest.of(content, ImageArchiveManifest::new);
    }

    public static class ManifestEntry
    extends MappedObject {
        private final List<String> layers = this.extractLayers();

        protected ManifestEntry(JsonNode node) {
            super(node, MethodHandles.lookup());
        }

        public List<String> getLayers() {
            return this.layers;
        }

        static ManifestEntry of(JsonNode node) {
            return new ManifestEntry(node);
        }

        private List<String> extractLayers() {
            List layers = this.valueAt("/Layers", List.class);
            if (layers == null) {
                return Collections.emptyList();
            }
            return layers;
        }
    }
}

