/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker.type;

import cn.taketoday.buildpack.platform.io.TarArchive;
import cn.taketoday.lang.Assert;

public interface ContainerContent {
    public TarArchive getArchive();

    public String getDestinationPath();

    public static ContainerContent of(TarArchive archive) {
        return ContainerContent.of(archive, "/");
    }

    public static ContainerContent of(final TarArchive archive, final String destinationPath) {
        Assert.notNull((Object)archive, (String)"Archive is required");
        Assert.hasText((String)destinationPath, (String)"DestinationPath must not be empty");
        return new ContainerContent(){

            @Override
            public TarArchive getArchive() {
                return archive;
            }

            @Override
            public String getDestinationPath() {
                return destinationPath;
            }
        };
    }
}

