/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker.type;

import cn.taketoday.buildpack.platform.docker.type.VolumeName;
import cn.taketoday.lang.Assert;
import java.util.Objects;

public final class Binding {
    private final String value;

    private Binding(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)obj;
        return Objects.equals(this.value, binding.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    public static Binding of(String value) {
        Assert.notNull((Object)value, (String)"Value is required");
        return new Binding(value);
    }

    public static Binding from(VolumeName sourceVolume, String destination) {
        Assert.notNull((Object)sourceVolume, (String)"SourceVolume is required");
        return Binding.from(sourceVolume.toString(), destination);
    }

    public static Binding from(String source, String destination) {
        Assert.notNull((Object)source, (String)"Source is required");
        Assert.notNull((Object)destination, (String)"Destination is required");
        return new Binding(source + ":" + destination);
    }
}

