/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker.transport;

import cn.taketoday.buildpack.platform.docker.configuration.DockerHost;
import cn.taketoday.buildpack.platform.docker.configuration.ResolvedDockerHost;
import cn.taketoday.buildpack.platform.docker.ssl.SslContextFactory;
import cn.taketoday.buildpack.platform.docker.transport.HttpClientTransport;
import cn.taketoday.lang.Assert;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.Timeout;

final class RemoteHttpClientTransport
extends HttpClientTransport {
    private static final Timeout SOCKET_TIMEOUT = Timeout.of((long)30L, (TimeUnit)TimeUnit.MINUTES);

    private RemoteHttpClientTransport(HttpClient client, HttpHost host) {
        super(client, host);
    }

    static RemoteHttpClientTransport createIfPossible(ResolvedDockerHost dockerHost) {
        return RemoteHttpClientTransport.createIfPossible(dockerHost, new SslContextFactory());
    }

    static RemoteHttpClientTransport createIfPossible(ResolvedDockerHost dockerHost, SslContextFactory sslContextFactory) {
        if (!dockerHost.isRemote()) {
            return null;
        }
        try {
            return RemoteHttpClientTransport.create(dockerHost, sslContextFactory, HttpHost.create((String)dockerHost.getAddress()));
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    private static RemoteHttpClientTransport create(DockerHost host, SslContextFactory sslContextFactory, HttpHost tcpHost) {
        SocketConfig socketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(SOCKET_TIMEOUT).build();
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(socketConfig);
        if (host.isSecure()) {
            connectionManagerBuilder.setSSLSocketFactory(RemoteHttpClientTransport.getSecureConnectionSocketFactory(host, sslContextFactory));
        }
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)connectionManagerBuilder.build());
        String scheme = host.isSecure() ? "https" : "http";
        HttpHost httpHost = new HttpHost(scheme, tcpHost.getHostName(), tcpHost.getPort());
        return new RemoteHttpClientTransport((HttpClient)builder.build(), httpHost);
    }

    private static LayeredConnectionSocketFactory getSecureConnectionSocketFactory(DockerHost host, SslContextFactory sslContextFactory) {
        String directory = host.getCertificatePath();
        Assert.hasText((String)directory, () -> "Docker host TLS verification requires trust material location to be specified with certificate path");
        SSLContext sslContext = sslContextFactory.forDirectory(directory);
        return new SSLConnectionSocketFactory(sslContext);
    }
}

