/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker.transport;

import cn.taketoday.buildpack.platform.docker.configuration.DockerConfiguration;
import cn.taketoday.buildpack.platform.docker.configuration.ResolvedDockerHost;
import cn.taketoday.buildpack.platform.docker.transport.LocalHttpClientTransport;
import cn.taketoday.buildpack.platform.docker.transport.RemoteHttpClientTransport;
import cn.taketoday.buildpack.platform.io.IOConsumer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public interface HttpTransport {
    public Response get(URI var1) throws IOException;

    public Response post(URI var1) throws IOException;

    public Response post(URI var1, String var2) throws IOException;

    public Response post(URI var1, String var2, IOConsumer<OutputStream> var3) throws IOException;

    public Response put(URI var1, String var2, IOConsumer<OutputStream> var3) throws IOException;

    public Response delete(URI var1) throws IOException;

    public static HttpTransport create(DockerConfiguration.DockerHostConfiguration dockerHost) {
        ResolvedDockerHost host = ResolvedDockerHost.from(dockerHost);
        RemoteHttpClientTransport remote = RemoteHttpClientTransport.createIfPossible(host);
        return remote != null ? remote : LocalHttpClientTransport.create(host);
    }

    public static interface Response
    extends Closeable {
        public InputStream getContent() throws IOException;
    }
}

