/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker.transport;

import cn.taketoday.lang.Assert;
import cn.taketoday.util.StringUtils;

public class DockerConnectionException
extends RuntimeException {
    private static final String JNA_EXCEPTION_CLASS_NAME = "com.sun.jna.LastErrorException";

    public DockerConnectionException(String host, Exception cause) {
        super(DockerConnectionException.buildMessage(host, cause), cause);
    }

    private static String buildMessage(String host, Exception cause) {
        Assert.notNull((Object)host, (String)"Host is required");
        Assert.notNull((Object)cause, (String)"Cause is required");
        StringBuilder message = new StringBuilder("Connection to the Docker daemon at '" + host + "' failed");
        String causeMessage = DockerConnectionException.getCauseMessage(cause);
        if (StringUtils.hasText((String)causeMessage)) {
            message.append(" with error \"").append(causeMessage).append("\"");
        }
        message.append("; ensure the Docker daemon is running and accessible");
        return message.toString();
    }

    private static String getCauseMessage(Exception cause) {
        if (cause.getCause() != null && cause.getCause().getClass().getName().equals(JNA_EXCEPTION_CLASS_NAME)) {
            return cause.getCause().getMessage();
        }
        return cause.getMessage();
    }
}

