/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker.ssl;

import cn.taketoday.buildpack.platform.docker.ssl.KeyStoreFactory;
import cn.taketoday.lang.Assert;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SslContextFactory {
    private static final char[] NO_PASSWORD = new char[0];
    private static final String KEY_STORE_ALIAS = "infra-app-docker";

    public SSLContext forDirectory(String directory) {
        try {
            Path keyPath = Paths.get(directory, "key.pem");
            Path certPath = Paths.get(directory, "cert.pem");
            Path caPath = Paths.get(directory, "ca.pem");
            Path caKeyPath = Paths.get(directory, "ca-key.pem");
            SslContextFactory.verifyCertificateFiles(keyPath, certPath, caPath);
            KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory(keyPath, certPath);
            TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(caPath, caKeyPath);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private KeyManagerFactory getKeyManagerFactory(Path keyPath, Path certPath) throws Exception {
        KeyStore store = KeyStoreFactory.create(certPath, keyPath, KEY_STORE_ALIAS);
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(store, NO_PASSWORD);
        return factory;
    }

    private TrustManagerFactory getTrustManagerFactory(Path caPath, Path caKeyPath) throws NoSuchAlgorithmException, KeyStoreException {
        KeyStore store = KeyStoreFactory.create(caPath, caKeyPath, KEY_STORE_ALIAS);
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(store);
        return factory;
    }

    private static void verifyCertificateFiles(Path ... paths) {
        for (Path path : paths) {
            Assert.state((Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) ? 1 : 0) != 0, (String)"Certificate path must contain the files 'ca.pem', 'cert.pem', and 'key.pem' files");
        }
    }
}

