/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker;

import cn.taketoday.buildpack.platform.docker.TotalProgressEvent;
import java.io.PrintStream;
import java.util.function.Consumer;

public class TotalProgressBar
implements Consumer<TotalProgressEvent> {
    private final char progressChar;
    private final boolean bookend;
    private final PrintStream out;
    private int printed;

    public TotalProgressBar(String prefix) {
        this(prefix, System.out);
    }

    public TotalProgressBar(String prefix, PrintStream out) {
        this(prefix, '#', true, out);
    }

    public TotalProgressBar(String prefix, char progressChar, boolean bookend, PrintStream out) {
        this.progressChar = progressChar;
        this.bookend = bookend;
        if (prefix != null && !prefix.isEmpty()) {
            out.print(prefix);
            out.print(" ");
        }
        if (bookend) {
            out.print("[ ");
        }
        this.out = out;
    }

    @Override
    public void accept(TotalProgressEvent event) {
        int percent = event.getPercent() / 2;
        while (this.printed < percent) {
            this.out.print(this.progressChar);
            ++this.printed;
        }
        if (event.getPercent() == 100) {
            this.out.println(this.bookend ? " ]" : "");
        }
    }
}

