/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.docker;

import cn.taketoday.buildpack.platform.docker.UpdateEvent;
import com.fasterxml.jackson.annotation.JsonCreator;

public abstract class ProgressUpdateEvent
extends UpdateEvent {
    private final String status;
    private final ProgressDetail progressDetail;
    private final String progress;

    protected ProgressUpdateEvent(String status, ProgressDetail progressDetail, String progress) {
        this.status = status;
        this.progressDetail = ProgressDetail.isEmpty(progressDetail) ? null : progressDetail;
        this.progress = progress;
    }

    public String getStatus() {
        return this.status;
    }

    public ProgressDetail getProgressDetail() {
        return this.progressDetail;
    }

    public String getProgress() {
        return this.progress;
    }

    public static class ProgressDetail {
        private final Integer current;
        private final Integer total;

        @JsonCreator
        public ProgressDetail(Integer current, Integer total) {
            this.current = current;
            this.total = total;
        }

        public int getCurrent() {
            return this.current;
        }

        public int getTotal() {
            return this.total;
        }

        public static boolean isEmpty(ProgressDetail progressDetail) {
            return progressDetail == null || progressDetail.current == null || progressDetail.total == null;
        }
    }
}

