/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.Buildpack;
import cn.taketoday.buildpack.platform.build.BuildpackCoordinates;
import cn.taketoday.buildpack.platform.build.BuildpackReference;
import cn.taketoday.buildpack.platform.build.BuildpackResolverContext;
import cn.taketoday.buildpack.platform.docker.type.Layer;
import cn.taketoday.buildpack.platform.io.IOConsumer;
import cn.taketoday.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

final class TarGzipBuildpack
implements Buildpack {
    private final Path path;
    private final BuildpackCoordinates coordinates;

    private TarGzipBuildpack(Path path) {
        this.path = path;
        this.coordinates = this.findBuildpackCoordinates(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BuildpackCoordinates findBuildpackCoordinates(Path path) {
        try (TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(Files.newInputStream(path, new OpenOption[0])));){
            TarArchiveEntry entry = tar.getNextEntry();
            while (entry != null) {
                if ("buildpack.toml".equals(entry.getName())) {
                    BuildpackCoordinates buildpackCoordinates = BuildpackCoordinates.fromToml((InputStream)tar, path);
                    return buildpackCoordinates;
                }
                entry = tar.getNextEntry();
            }
            throw new IllegalArgumentException("Buildpack descriptor 'buildpack.toml' is required in buildpack '" + path + "'");
        }
        catch (IOException ex) {
            throw new RuntimeException("Error parsing descriptor for buildpack '" + path + "'", ex);
        }
    }

    @Override
    public BuildpackCoordinates getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void apply(IOConsumer<Layer> layers) throws IOException {
        layers.accept(Layer.fromTarArchive(this::copyAndRebaseEntries));
    }

    private void copyAndRebaseEntries(OutputStream outputStream) throws IOException {
        String id = this.coordinates.getSanitizedId();
        Path basePath = Paths.get("/cnb/buildpacks/", id, this.coordinates.getVersion());
        try (TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(Files.newInputStream(this.path, new OpenOption[0])));
             TarArchiveOutputStream output = new TarArchiveOutputStream(outputStream);){
            this.writeBasePathEntries(output, basePath);
            TarArchiveEntry entry = tar.getNextEntry();
            while (entry != null) {
                entry.setName(basePath + "/" + entry.getName());
                output.putArchiveEntry(entry);
                StreamUtils.copy((InputStream)tar, (OutputStream)output);
                output.closeArchiveEntry();
                entry = tar.getNextEntry();
            }
            output.finish();
        }
    }

    private void writeBasePathEntries(TarArchiveOutputStream output, Path basePath) throws IOException {
        int pathCount = basePath.getNameCount();
        for (int pathIndex = 1; pathIndex < pathCount + 1; ++pathIndex) {
            String name = "/" + basePath.subpath(0, pathIndex) + "/";
            TarArchiveEntry entry = new TarArchiveEntry(name);
            output.putArchiveEntry(entry);
            output.closeArchiveEntry();
        }
    }

    static Buildpack resolve(BuildpackResolverContext context, BuildpackReference reference) {
        Path path = reference.asPath();
        if (path != null && Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            return new TarGzipBuildpack(path);
        }
        return null;
    }
}

