/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.docker.type.Image;
import cn.taketoday.buildpack.platform.docker.type.ImageConfig;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.StringUtils;

class StackId {
    private static final String LABEL_NAME = "io.buildpacks.stack.id";
    private final String value;

    StackId(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((StackId)obj).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    static StackId fromImage(Image image) {
        Assert.notNull((Object)image, (String)"Image is required");
        return StackId.fromImageConfig(image.getConfig());
    }

    private static StackId fromImageConfig(ImageConfig imageConfig) {
        String value = imageConfig.getLabels().get(LABEL_NAME);
        Assert.state((boolean)StringUtils.hasText((String)value), () -> "Missing 'io.buildpacks.stack.id' stack label");
        return new StackId(value);
    }

    static StackId of(String value) {
        Assert.hasText((String)value, (String)"Value must not be empty");
        return new StackId(value);
    }
}

